package cn.gtmap.realestate.common.core.domain.building;


import cn.gtmap.realestate.common.core.dto.building.DjDcbResponseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018/11/8
 * @description
 */
@Table(name="cbzd_dcb")
@ApiModel(value = "CbzdDcbDO", description = "承包宗地调查表基本信息")
public class CbzdDcbDO{
    @Id
    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private String cbzdDcbIndex;
    /**
     * 宗地调查表主键
     */
    @ApiModelProperty(value = "宗地调查表主键")
    private String zddcbIndex;
    /**
     * 地籍号
     */
    @ApiModelProperty(value = "地籍号")
    private String djh;
    /**
     * 不动产单元号
     */
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    /**
     * 土地用途
     */
    @ApiModelProperty(value = "土地用途")
    private String tdyt;
    /**
     * 地力等级
     */
    @ApiModelProperty(value = "地力等级")
    private String dldj;
    /**
     * 是否基本农田
     */
    @ApiModelProperty(value = "是否基本农田")
    private String sfjbnt;
    /**
     * 水域滩涂类型
     */
    @ApiModelProperty(value = "水域滩涂类型")
    private String syttlx;
    /**
     * 养殖业方式
     */
    @ApiModelProperty(value = "养殖业方式")
    private String yzyfs;
    /**
     * 适宜载畜量
     */
    @ApiModelProperty(value = "适宜载畜量")
    private Integer syzxl;
    /**
     * 草层高度
     */
    @ApiModelProperty(value = "草层高度")
    private Double ccgd;
    /**
     * 草地覆盖度
     */
    @ApiModelProperty(value = "草地覆盖度")
    private Double cdfgd;
    /**
     * 建群
     */
    @ApiModelProperty(value = "建群")
    private String cdjq;
    /**
     * 优势种
     */
    @ApiModelProperty(value = "优势种")
    private String cdysz;
    /**
     * 调查记事
     */
    @ApiModelProperty(value = "调查记事")
    private String dcjs;
    /**
     * 调查员
     */
    @ApiModelProperty(value = "调查员")
    private String dcy;
    /**
     * 调查日期
     */
    @ApiModelProperty(value = "调查日期",example = "2018-10-01 12:18:21")
    private Date dcrq;
    /**
     * 审核意见
     */
    @ApiModelProperty(value = "审核意见")
    private String shyj;
    /**
     * 审核人
     */
    @ApiModelProperty(value = "审核人")
    private String shr;
    /**
     * 审核日期
     */
    @ApiModelProperty(value = "审核日期",example = "2018-10-01 12:18:21")
    private Date shrq;
    /**
     * 更新日期
     */
    @ApiModelProperty(value = "更新日期",example = "2018-10-01 12:18:21")
    private Date gxrq;
    /**
     * 家庭标示
     */
    @ApiModelProperty(value = "家庭标示")
    private String jtIndex;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String bz;

    public String getCbzdDcbIndex() {
        return cbzdDcbIndex;
    }

    public void setCbzdDcbIndex(String cbzdDcbIndex) {
        this.cbzdDcbIndex = cbzdDcbIndex;
    }

    public String getZddcbIndex() {
        return zddcbIndex;
    }

    public void setZddcbIndex(String zddcbIndex) {
        this.zddcbIndex = zddcbIndex;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public String getDldj() {
        return dldj;
    }

    public void setDldj(String dldj) {
        this.dldj = dldj;
    }

    public String getSfjbnt() {
        return sfjbnt;
    }

    public void setSfjbnt(String sfjbnt) {
        this.sfjbnt = sfjbnt;
    }

    public String getSyttlx() {
        return syttlx;
    }

    public void setSyttlx(String syttlx) {
        this.syttlx = syttlx;
    }

    public String getYzyfs() {
        return yzyfs;
    }

    public void setYzyfs(String yzyfs) {
        this.yzyfs = yzyfs;
    }

    public Integer getSyzxl() {
        return syzxl;
    }

    public void setSyzxl(Integer syzxl) {
        this.syzxl = syzxl;
    }

    public Double getCcgd() {
        return ccgd;
    }

    public void setCcgd(Double ccgd) {
        this.ccgd = ccgd;
    }

    public Double getCdfgd() {
        return cdfgd;
    }

    public void setCdfgd(Double cdfgd) {
        this.cdfgd = cdfgd;
    }

    public String getCdjq() {
        return cdjq;
    }

    public void setCdjq(String cdjq) {
        this.cdjq = cdjq;
    }

    public String getCdysz() {
        return cdysz;
    }

    public void setCdysz(String cdysz) {
        this.cdysz = cdysz;
    }

    public String getDcjs() {
        return dcjs;
    }

    public void setDcjs(String dcjs) {
        this.dcjs = dcjs;
    }

    public String getDcy() {
        return dcy;
    }

    public void setDcy(String dcy) {
        this.dcy = dcy;
    }

    public Date getDcrq() {
        return dcrq;
    }

    public void setDcrq(Date dcrq) {
        this.dcrq = dcrq;
    }

    public String getShyj() {
        return shyj;
    }

    public void setShyj(String shyj) {
        this.shyj = shyj;
    }

    public String getShr() {
        return shr;
    }

    public void setShr(String shr) {
        this.shr = shr;
    }

    public Date getShrq() {
        return shrq;
    }

    public void setShrq(Date shrq) {
        this.shrq = shrq;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }

    public String getJtIndex() {
        return jtIndex;
    }

    public void setJtIndex(String jtIndex) {
        this.jtIndex = jtIndex;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @Override
    public String toString() {
        return "CbzdDcbDO{" +
                "cbzdDcbIndex='" + cbzdDcbIndex + '\'' +
                ", zddcbIndex='" + zddcbIndex + '\'' +
                ", djh='" + djh + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", tdyt='" + tdyt + '\'' +
                ", dldj='" + dldj + '\'' +
                ", sfjbnt='" + sfjbnt + '\'' +
                ", syttlx='" + syttlx + '\'' +
                ", yzyfs='" + yzyfs + '\'' +
                ", syzxl=" + syzxl +
                ", ccgd=" + ccgd +
                ", cdfgd=" + cdfgd +
                ", cdjq='" + cdjq + '\'' +
                ", cdysz='" + cdysz + '\'' +
                ", dcjs='" + dcjs + '\'' +
                ", dcy='" + dcy + '\'' +
                ", dcrq=" + dcrq +
                ", shyj='" + shyj + '\'' +
                ", shr='" + shr + '\'' +
                ", shrq=" + shrq +
                ", gxrq=" + gxrq +
                ", jtIndex='" + jtIndex + '\'' +
                ", bz='" + bz + '\'' +
                '}';
    }
}