package cn.gtmap.realestate.common.core.domain.accept;

import cn.gtmap.realestate.common.util.UUIDGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/5
 * @description 不动产受理项目
 */
@Table(name = "BDC_SL_XM")
@ApiModel(value = "BdcSlXmDO", description = "不动产受理项目")
public class BdcSlXmDO implements Serializable {
    @Id
    @ApiModelProperty(value = "项目ID")
    private String xmid;
    @ApiModelProperty(value = "基本信息ID")
    private String jbxxid;
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    @ApiModelProperty(value = "权籍ID")
    private String qjid;
    @ApiModelProperty(value = "不动产类型")
    private Integer bdclx;
    @ApiModelProperty(value = "权利类型")
    private Integer qllx;
    @ApiModelProperty(value = "登记小类")
    private String djxl;
    @ApiModelProperty(value = "原不动产权证")
    private String ybdcqz;
    @ApiModelProperty(value = "坐落")
    private String zl;
    @ApiModelProperty(value = "权利人")
    private String qlr;
    @ApiModelProperty(value = "抵押金额")
    private Double dyje;
    @ApiModelProperty(value = "抵押方式")
    private Integer dyfs;
    @ApiModelProperty(value = "债务履行起始时间",example = "2018-10-01 12:18:48")
    private Date zwlxqssj;
    @ApiModelProperty(value = "债务履行结束时间",example = "2018-10-01 12:18:48")
    private Date zwlxjssj;
    @ApiModelProperty(value = "在建建筑物坐落")
    private String zjjzwzl;
    @ApiModelProperty(value = "在建建筑物抵押范围")
    private String zjjzwdyfw;
    @ApiModelProperty(value = "最高债权确定事实")
    private String zgzqqdss;
    @ApiModelProperty(value = "担保范围")
    private String dbfw;
    @ApiModelProperty(value = "贷款方式")
    private String dkfs;
    @ApiModelProperty(value = "被担保主债权数额")
    private Double bdbzzqse;
    @ApiModelProperty(value = "房屋评估价格")
    private Double fwpgjg;
    @ApiModelProperty(value = "土地评估价格")
    private Double tdpgjg;
    @ApiModelProperty(value = "查封机关")
    private String cfjg;
    @ApiModelProperty(value = "查封类型")
    private Integer cflx;
    @ApiModelProperty(value = "查封文号")
    private String cfwh;
    @ApiModelProperty(value = "查封范围")
    private String cffw;
    @ApiModelProperty(value = "查封起始时间",example = "2018-10-01 12:18:48")
    private Date cfqssj;
    @ApiModelProperty(value = "查封结束时间",example = "2018-10-01 12:18:48")
    private Date cfjssj;
    @ApiModelProperty(value = "执行申请人")
    private String zxsqr;
    @ApiModelProperty(value = "被执行人")
    private String bzxr;
    @ApiModelProperty(value = "查封原因")
    private String cfyy;
    @ApiModelProperty(value = "轮候查封期限")
    private String lhcfqx;
    @ApiModelProperty(value = "法院送达人")
    private String fysdr;
    @ApiModelProperty(value = "预告登记种类")
    private Integer ygdjzl;
    @ApiModelProperty(value = "取得价格/主债权数额")
    private Double qdjg;
    @ApiModelProperty(value = "共有情况")
    private String gyqk;
    @ApiModelProperty(value = "预告债务履行起始时间",example = "2018-10-01 12:18:48")
    private Date ygzwlxqssj;
    @ApiModelProperty(value = "预告债务履行结束时间",example = "2018-10-01 12:18:48")
    private Date ygzwlxjssj;
    @ApiModelProperty(value = "预告抵押方式")
    private Integer ygdyfs;
    @ApiModelProperty(value = "异议事项")
    private String yysx;
    @ApiModelProperty(value = "使用权（承包方）面积")
    private Double syqmj;
    @ApiModelProperty(value = "林地使用（承包）开始期限",example = "2018-10-01 12:18:48")
    private Date ldsyksqx;
    @ApiModelProperty(value = "林地使用（承包）结束期限",example = "2018-10-01 12:18:48")
    private Date ldsyjsqx;
    @ApiModelProperty(value = "林地所有权性质")
    private Integer ldsyqxz;
    @ApiModelProperty(value = "森林、林木所有权人")
    private String sllmsyqr1;
    @ApiModelProperty(value = "森林、林木使用权人")
    private String sllmsyqr2;
    @ApiModelProperty(value = "主要树种")
    private String zysz;
    @ApiModelProperty(value = "株数")
    private Integer zs;
    @ApiModelProperty(value = "林种")
    private Integer lz;
    @ApiModelProperty(value = "起源")
    private Integer qy;
    @ApiModelProperty(value = "造林年度")
    private Integer zlnd;
    @ApiModelProperty(value = "小地名")
    private String xdm;
    @ApiModelProperty(value = "林班")
    private String lb;
    @ApiModelProperty(value = "小班")
    private String xb;
    @ApiModelProperty(value = "宗地宗海用途")
    private Integer zdzhyt;
    @ApiModelProperty(value = "宗地宗海面积")
    private Double zdzhmj;
    @ApiModelProperty(value = "需地役坐落")
    private String xdyzl;
    @ApiModelProperty(value = "需地役不动产单元号")
    private String xdybdcdyh;
    @ApiModelProperty(value = "权利人数据来源 1：权籍 2：上一手权利人 3：上一手义务人")
    private Integer qlrsjly;
    @ApiModelProperty(value = "义务人数据来源 1：权籍 2：上一手权利人 3：上一手义务人")
    private Integer ywrsjly;
    @ApiModelProperty(value = "是否生成权利 0：否  1：是")
    private Integer sfscql;
    @ApiModelProperty(value = "权利数据来源 1：权籍 2：上一手  可组合(1,2)")
    private String qlsjly;
    @ApiModelProperty(value = "证书种类   1：证书  2：证明")
    private Integer zszl;
    @ApiModelProperty(value = "证书序号：用于组合发证 分组")
    private Integer zsxh;
    @ApiModelProperty(value = "是否增量初始化业务  0：否  1：是")
    private Integer sfzlcsh;
    @ApiModelProperty(value = "不动产单元房屋类型")
    private Integer bdcdyfwlx;
    @ApiModelProperty(value = "操作人ID")
    private String czrid;
    @ApiModelProperty(value = "操作时间",example = "2018-10-01 12:18:48")
    private Date czsj;
    @ApiModelProperty(value = "是否主房  0：否  1：是")
    private Integer sfzf;
    @ApiModelProperty(value = "是否还原原注销权利  0：否  1：是")
    private Integer sfhyyzxql;
    @ApiModelProperty(value = "是否换证  0：否  1：是")
    private Integer sfhz;
    @ApiModelProperty(value = "登记原因")
    private String djyy;
    @ApiModelProperty(value = "是否房查(房屋信息查询)  0：否  1：是")
    private Integer sffc;
    @ApiModelProperty(value = "备注")
    private String bz;
    @ApiModelProperty(value = "是否分别持证  0：否  1：是")
    private Integer sqfbcz;
    @ApiModelProperty(value = "宗地宗海用途2")
    private String zdzhyt2;
    @ApiModelProperty(value = "宗地宗海用途3")
    private String zdzhyt3;
    @ApiModelProperty(value = "权利性质")
    private String qlxz;
    @ApiModelProperty(value = "项目业务类型 0：登记 1:一窗受理 9：其他")
    private Integer xmywlx;


    public BdcSlXmDO(String czrid) {
        this.xmid = UUIDGenerator.generate16();
        this.sfzlcsh = 0;
        this.czrid = czrid;
        this.czsj = new Date(System.currentTimeMillis());
    }

    public BdcSlXmDO() {
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getJbxxid() {
        return jbxxid;
    }

    public void setJbxxid(String jbxxid) {
        this.jbxxid = jbxxid;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getQjid() {
        return qjid;
    }

    public void setQjid(String qjid) {
        this.qjid = qjid;
    }

    public Integer getBdclx() {
        return bdclx;
    }

    public void setBdclx(Integer bdclx) {
        this.bdclx = bdclx;
    }

    public Integer getQllx() {
        return qllx;
    }

    public void setQllx(Integer qllx) {
        this.qllx = qllx;
    }

    public String getDjxl() {
        return djxl;
    }

    public void setDjxl(String djxl) {
        this.djxl = djxl;
    }

    public String getYbdcqz() {
        return ybdcqz;
    }

    public void setYbdcqz(String ybdcqz) {
        this.ybdcqz = ybdcqz;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getQlr() {
        return qlr;
    }

    public void setQlr(String qlr) {
        this.qlr = qlr;
    }

    public Double getDyje() {
        return dyje;
    }

    public void setDyje(Double dyje) {
        this.dyje = dyje;
    }

    public Integer getDyfs() {
        return dyfs;
    }

    public void setDyfs(Integer dyfs) {
        this.dyfs = dyfs;
    }

    public Date getZwlxqssj() {
        return zwlxqssj;
    }

    public void setZwlxqssj(Date zwlxqssj) {
        this.zwlxqssj = zwlxqssj;
    }

    public Date getZwlxjssj() {
        return zwlxjssj;
    }

    public void setZwlxjssj(Date zwlxjssj) {
        this.zwlxjssj = zwlxjssj;
    }

    public String getZjjzwzl() {
        return zjjzwzl;
    }

    public void setZjjzwzl(String zjjzwzl) {
        this.zjjzwzl = zjjzwzl;
    }

    public String getZjjzwdyfw() {
        return zjjzwdyfw;
    }

    public void setZjjzwdyfw(String zjjzwdyfw) {
        this.zjjzwdyfw = zjjzwdyfw;
    }

    public String getZgzqqdss() {
        return zgzqqdss;
    }

    public void setZgzqqdss(String zgzqqdss) {
        this.zgzqqdss = zgzqqdss;
    }

    public String getDbfw() {
        return dbfw;
    }

    public void setDbfw(String dbfw) {
        this.dbfw = dbfw;
    }

    public String getDkfs() {
        return dkfs;
    }

    public void setDkfs(String dkfs) {
        this.dkfs = dkfs;
    }

    public Double getBdbzzqse() {
        return bdbzzqse;
    }

    public void setBdbzzqse(Double bdbzzqse) {
        this.bdbzzqse = bdbzzqse;
    }

    public Double getFwpgjg() {
        return fwpgjg;
    }

    public void setFwpgjg(Double fwpgjg) {
        this.fwpgjg = fwpgjg;
    }

    public Double getTdpgjg() {
        return tdpgjg;
    }

    public void setTdpgjg(Double tdpgjg) {
        this.tdpgjg = tdpgjg;
    }

    public String getCfjg() {
        return cfjg;
    }

    public void setCfjg(String cfjg) {
        this.cfjg = cfjg;
    }

    public Integer getCflx() {
        return cflx;
    }

    public void setCflx(Integer cflx) {
        this.cflx = cflx;
    }

    public String getCfwh() {
        return cfwh;
    }

    public void setCfwh(String cfwh) {
        this.cfwh = cfwh;
    }

    public String getCffw() {
        return cffw;
    }

    public void setCffw(String cffw) {
        this.cffw = cffw;
    }

    public Date getCfqssj() {
        return cfqssj;
    }

    public void setCfqssj(Date cfqssj) {
        this.cfqssj = cfqssj;
    }

    public Date getCfjssj() {
        return cfjssj;
    }

    public void setCfjssj(Date cfjssj) {
        this.cfjssj = cfjssj;
    }

    public String getZxsqr() {
        return zxsqr;
    }

    public void setZxsqr(String zxsqr) {
        this.zxsqr = zxsqr;
    }

    public String getBzxr() {
        return bzxr;
    }

    public void setBzxr(String bzxr) {
        this.bzxr = bzxr;
    }

    public String getCfyy() {
        return cfyy;
    }

    public void setCfyy(String cfyy) {
        this.cfyy = cfyy;
    }

    public String getLhcfqx() {
        return lhcfqx;
    }

    public void setLhcfqx(String lhcfqx) {
        this.lhcfqx = lhcfqx;
    }

    public String getFysdr() {
        return fysdr;
    }

    public void setFysdr(String fysdr) {
        this.fysdr = fysdr;
    }

    public Integer getYgdjzl() {
        return ygdjzl;
    }

    public void setYgdjzl(Integer ygdjzl) {
        this.ygdjzl = ygdjzl;
    }

    public Double getQdjg() {
        return qdjg;
    }

    public void setQdjg(Double qdjg) {
        this.qdjg = qdjg;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public Date getYgzwlxqssj() {
        return ygzwlxqssj;
    }

    public void setYgzwlxqssj(Date ygzwlxqssj) {
        this.ygzwlxqssj = ygzwlxqssj;
    }

    public Date getYgzwlxjssj() {
        return ygzwlxjssj;
    }

    public void setYgzwlxjssj(Date ygzwlxjssj) {
        this.ygzwlxjssj = ygzwlxjssj;
    }

    public Integer getYgdyfs() {
        return ygdyfs;
    }

    public void setYgdyfs(Integer ygdyfs) {
        this.ygdyfs = ygdyfs;
    }

    public String getYysx() {
        return yysx;
    }

    public void setYysx(String yysx) {
        this.yysx = yysx;
    }

    public Double getSyqmj() {
        return syqmj;
    }

    public void setSyqmj(Double syqmj) {
        this.syqmj = syqmj;
    }

    public Date getLdsyksqx() {
        return ldsyksqx;
    }

    public void setLdsyksqx(Date ldsyksqx) {
        this.ldsyksqx = ldsyksqx;
    }

    public Date getLdsyjsqx() {
        return ldsyjsqx;
    }

    public void setLdsyjsqx(Date ldsyjsqx) {
        this.ldsyjsqx = ldsyjsqx;
    }

    public Integer getLdsyqxz() {
        return ldsyqxz;
    }

    public void setLdsyqxz(Integer ldsyqxz) {
        this.ldsyqxz = ldsyqxz;
    }

    public String getSllmsyqr1() {
        return sllmsyqr1;
    }

    public void setSllmsyqr1(String sllmsyqr1) {
        this.sllmsyqr1 = sllmsyqr1;
    }

    public String getSllmsyqr2() {
        return sllmsyqr2;
    }

    public void setSllmsyqr2(String sllmsyqr2) {
        this.sllmsyqr2 = sllmsyqr2;
    }

    public String getZysz() {
        return zysz;
    }

    public void setZysz(String zysz) {
        this.zysz = zysz;
    }

    public Integer getZs() {
        return zs;
    }

    public void setZs(Integer zs) {
        this.zs = zs;
    }

    public Integer getLz() {
        return lz;
    }

    public void setLz(Integer lz) {
        this.lz = lz;
    }

    public Integer getQy() {
        return qy;
    }

    public void setQy(Integer qy) {
        this.qy = qy;
    }

    public Integer getZlnd() {
        return zlnd;
    }

    public void setZlnd(Integer zlnd) {
        this.zlnd = zlnd;
    }

    public String getXdm() {
        return xdm;
    }

    public void setXdm(String xdm) {
        this.xdm = xdm;
    }

    public String getLb() {
        return lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    public String getXb() {
        return xb;
    }

    public void setXb(String xb) {
        this.xb = xb;
    }

    public Integer getZdzhyt() {
        return zdzhyt;
    }

    public void setZdzhyt(Integer zdzhyt) {
        this.zdzhyt = zdzhyt;
    }

    public Double getZdzhmj() {
        return zdzhmj;
    }

    public void setZdzhmj(Double zdzhmj) {
        this.zdzhmj = zdzhmj;
    }

    public String getXdyzl() {
        return xdyzl;
    }

    public void setXdyzl(String xdyzl) {
        this.xdyzl = xdyzl;
    }

    public String getXdybdcdyh() {
        return xdybdcdyh;
    }

    public void setXdybdcdyh(String xdybdcdyh) {
        this.xdybdcdyh = xdybdcdyh;
    }

    public Integer getQlrsjly() {
        return qlrsjly;
    }

    public void setQlrsjly(Integer qlrsjly) {
        this.qlrsjly = qlrsjly;
    }

    public Integer getYwrsjly() {
        return ywrsjly;
    }

    public void setYwrsjly(Integer ywrsjly) {
        this.ywrsjly = ywrsjly;
    }

    public Integer getSfscql() {
        return sfscql;
    }

    public void setSfscql(Integer sfscql) {
        this.sfscql = sfscql;
    }

    public String getQlsjly() {
        return qlsjly;
    }

    public void setQlsjly(String qlsjly) {
        this.qlsjly = qlsjly;
    }

    public Integer getZszl() {
        return zszl;
    }

    public void setZszl(Integer zszl) {
        this.zszl = zszl;
    }

    public Integer getZsxh() {
        return zsxh;
    }

    public void setZsxh(Integer zsxh) {
        this.zsxh = zsxh;
    }

    public Integer getSfzlcsh() {
        return sfzlcsh;
    }

    public void setSfzlcsh(Integer sfzlcsh) {
        this.sfzlcsh = sfzlcsh;
    }

    public Integer getBdcdyfwlx() {
        return bdcdyfwlx;
    }

    public void setBdcdyfwlx(Integer bdcdyfwlx) {
        this.bdcdyfwlx = bdcdyfwlx;
    }

    public String getCzrid() {
        return czrid;
    }

    public void setCzrid(String czrid) {
        this.czrid = czrid;
    }

    public Date getCzsj() {
        return czsj;
    }

    public void setCzsj(Date czsj) {
        this.czsj = czsj;
    }

    public Integer getSfzf() {
        return sfzf;
    }

    public void setSfzf(Integer sfzf) {
        this.sfzf = sfzf;
    }

    public Integer getSfhyyzxql() {
        return sfhyyzxql;
    }

    public void setSfhyyzxql(Integer sfhyyzxql) {
        this.sfhyyzxql = sfhyyzxql;
    }

    public Integer getSfhz() {
        return sfhz;
    }

    public void setSfhz(Integer sfhz) {
        this.sfhz = sfhz;
    }

    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    public Integer getSffc() {
        return sffc;
    }

    public void setSffc(Integer sffc) {
        this.sffc = sffc;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Integer getSqfbcz() {
        return sqfbcz;
    }

    public void setSqfbcz(Integer sqfbcz) {
        this.sqfbcz = sqfbcz;
    }

    public String getZdzhyt2() {
        return zdzhyt2;
    }

    public void setZdzhyt2(String zdzhyt2) {
        this.zdzhyt2 = zdzhyt2;
    }

    public String getZdzhyt3() {
        return zdzhyt3;
    }

    public void setZdzhyt3(String zdzhyt3) {
        this.zdzhyt3 = zdzhyt3;
    }

    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    public Integer getXmywlx() {
        return xmywlx;
    }

    public void setXmywlx(Integer xmywlx) {
        this.xmywlx = xmywlx;
    }

    @Override
    public String toString() {
        return "BdcSlXmDO{" +
                "xmid='" + xmid + '\'' +
                ", jbxxid='" + jbxxid + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", qjid='" + qjid + '\'' +
                ", bdclx=" + bdclx +
                ", qllx=" + qllx +
                ", djxl='" + djxl + '\'' +
                ", ybdcqz='" + ybdcqz + '\'' +
                ", zl='" + zl + '\'' +
                ", qlr='" + qlr + '\'' +
                ", dyje=" + dyje +
                ", dyfs=" + dyfs +
                ", zwlxqssj=" + zwlxqssj +
                ", zwlxjssj=" + zwlxjssj +
                ", zjjzwzl='" + zjjzwzl + '\'' +
                ", zjjzwdyfw='" + zjjzwdyfw + '\'' +
                ", zgzqqdss='" + zgzqqdss + '\'' +
                ", dbfw='" + dbfw + '\'' +
                ", dkfs='" + dkfs + '\'' +
                ", bdbzzqse=" + bdbzzqse +
                ", fwpgjg=" + fwpgjg +
                ", tdpgjg=" + tdpgjg +
                ", cfjg='" + cfjg + '\'' +
                ", cflx=" + cflx +
                ", cfwh='" + cfwh + '\'' +
                ", cffw='" + cffw + '\'' +
                ", cfqssj=" + cfqssj +
                ", cfjssj=" + cfjssj +
                ", zxsqr='" + zxsqr + '\'' +
                ", bzxr='" + bzxr + '\'' +
                ", cfyy='" + cfyy + '\'' +
                ", lhcfqx='" + lhcfqx + '\'' +
                ", fysdr='" + fysdr + '\'' +
                ", ygdjzl=" + ygdjzl +
                ", qdjg=" + qdjg +
                ", gyqk='" + gyqk + '\'' +
                ", ygzwlxqssj=" + ygzwlxqssj +
                ", ygzwlxjssj=" + ygzwlxjssj +
                ", ygdyfs=" + ygdyfs +
                ", yysx='" + yysx + '\'' +
                ", syqmj=" + syqmj +
                ", ldsyksqx=" + ldsyksqx +
                ", ldsyjsqx=" + ldsyjsqx +
                ", ldsyqxz=" + ldsyqxz +
                ", sllmsyqr1='" + sllmsyqr1 + '\'' +
                ", sllmsyqr2='" + sllmsyqr2 + '\'' +
                ", zysz='" + zysz + '\'' +
                ", zs=" + zs +
                ", lz=" + lz +
                ", qy=" + qy +
                ", zlnd=" + zlnd +
                ", xdm='" + xdm + '\'' +
                ", lb='" + lb + '\'' +
                ", xb='" + xb + '\'' +
                ", zdzhyt=" + zdzhyt +
                ", zdzhmj=" + zdzhmj +
                ", xdyzl='" + xdyzl + '\'' +
                ", xdybdcdyh='" + xdybdcdyh + '\'' +
                ", qlrsjly=" + qlrsjly +
                ", ywrsjly=" + ywrsjly +
                ", sfscql=" + sfscql +
                ", qlsjly='" + qlsjly + '\'' +
                ", zszl=" + zszl +
                ", zsxh=" + zsxh +
                ", sfzlcsh=" + sfzlcsh +
                ", bdcdyfwlx=" + bdcdyfwlx +
                ", czrid='" + czrid + '\'' +
                ", czsj=" + czsj +
                ", sfzf=" + sfzf +
                ", sfhyyzxql=" + sfhyyzxql +
                ", sfhz=" + sfhz +
                ", djyy='" + djyy + '\'' +
                ", sffc=" + sffc +
                ", bz='" + bz + '\'' +
                ", sqfbcz=" + sqfbcz +
                ", zdzhyt2='" + zdzhyt2 + '\'' +
                ", zdzhyt3='" + zdzhyt3 + '\'' +
                ", qlxz='" + qlxz + '\'' +
                '}';
    }
}
