package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/10/31
 * @description 不动产受理收费信息
 */
@Table(name = "BDC_SL_SFXX")
@ApiModel(value = "BdcSlSfxxDO", description = "不动产受理收费信息")
public class BdcSlSfxxDO implements Serializable {
    private static final long serialVersionUID = 8976331572255826712L;
    @Id
    @ApiModelProperty(value = "收费信息ID")
    private String sfxxid;
    @ApiModelProperty(value = "基本信息ID")
    private String jbxxid;
    @ApiModelProperty(value = "工作流实例ID")
    private String gzlslid;
    @ApiModelProperty(value = "项目ID")
    private String xmid;
    @ApiModelProperty(value = "收费时间")
    private Date sfsj;
    @ApiModelProperty(value = "金额单位")
    private String jedw;
    @ApiModelProperty(value = "合计")
    private Double hj;
    @ApiModelProperty(value = "备注")
    private String bz;
    @ApiModelProperty(value = "收费单初审人")
    private String sfdcsr;
    @ApiModelProperty(value = "收费单复审人")
    private String sfdfsr;
    @ApiModelProperty(value = "核收金额")
    private Double hsje;
    @ApiModelProperty(value = "收费单位名称")
    private String sfdwmc;
    @ApiModelProperty(value = "缴费人姓名")
    private String jfrxm;
    @ApiModelProperty(value = "收费人姓名")
    private String sfrxm;
    @ApiModelProperty(value = "收费人账号")
    private String sfrzh;
    @ApiModelProperty(value = "收费人开户银行")
    private String sfrkhyh;
    @ApiModelProperty(value = "收费单位代码")
    private String sfdwdm;
    @ApiModelProperty(value = "收费状态")
    private Integer sfzt;
    @ApiModelProperty(value = "收费状态操作人姓名")
    private String sfztczrxm;
    @ApiModelProperty(value = "收费状态操作时间")
    private Date sfztczsj;
    @ApiModelProperty(value = "发票号")
    private String fph;
    @ApiModelProperty(value = "财政条形码编号")
    private String cztxmbh;
    @ApiModelProperty(value = "付费方")
    private String fff;
    @ApiModelProperty(value = "权利人类别")
    private String qlrlb;
    @ApiModelProperty(value = "收费人开户银行网点代码")
    private String sfrkhyhwddm;
    @ApiModelProperty(value = "开票方式")
    private String kpfs;
	@ApiModelProperty(value = "开票人姓名")
	private String kprxm;
    @ApiModelProperty(value = "缴款方式")
    private String jkfs;
    @ApiModelProperty(value = "缴费书编码(缴费清单单号)")
    private String jfsbm;
    @ApiModelProperty(value = "缴费书二维码url")
    private String jfsewmurl;
    @ApiModelProperty(value = "义务人")
    private String ywr;
    @ApiModelProperty(value = "是否点击保存按钮")
    private Integer bczt;

    @ApiModelProperty(value = "银行缴库入库状态")
    private Integer yhjkrkzt;

    @ApiModelProperty(value = "退款单号")
    private String tkdh;

    @ApiModelProperty(value = "交易凭证号")
    private String jypzh;
	
	public String getKprxm() {
		return kprxm;
	}
	
	public void setKprxm(String kprxm) {
		this.kprxm = kprxm;
	}
	
	public String getSfxxid() {
        return sfxxid;
    }

    public void setSfxxid(String sfxxid) {
        this.sfxxid = sfxxid;
    }

    public Integer getYhjkrkzt() {
        return yhjkrkzt;
    }

    public void setYhjkrkzt(Integer yhjkrkzt) {
        this.yhjkrkzt = yhjkrkzt;
    }

    public String getJbxxid() {
        return jbxxid;
    }

    public void setJbxxid(String jbxxid) {
        this.jbxxid = jbxxid;
    }

    public String getGzlslid() {
        return gzlslid;
    }

    public void setGzlslid(String gzlslid) {
        this.gzlslid = gzlslid;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public Date getSfsj() {
        return sfsj;
    }

    public void setSfsj(Date sfsj) {
        this.sfsj = sfsj;
    }

    public String getJedw() {
        return jedw;
    }

    public void setJedw(String jedw) {
        this.jedw = jedw;
    }

    public Double getHj() {
        return hj;
    }

    public void setHj(Double hj) {
        this.hj = hj;
    }

    public String getSfdcsr() {
        return sfdcsr;
    }

    public void setSfdcsr(String sfdcsr) {
        this.sfdcsr = sfdcsr;
    }

    public String getSfdfsr() {
        return sfdfsr;
    }

    public void setSfdfsr(String sfdfsr) {
        this.sfdfsr = sfdfsr;
    }

    public Double getHsje() {
        return hsje;
    }

    public void setHsje(Double hsje) {
        this.hsje = hsje;
    }

    public String getSfdwmc() {
        return sfdwmc;
    }

    public void setSfdwmc(String sfdwmc) {
        this.sfdwmc = sfdwmc;
    }

    public String getJfrxm() {
        return jfrxm;
    }

    public void setJfrxm(String jfrxm) {
        this.jfrxm = jfrxm;
    }

    public String getSfrxm() {
        return sfrxm;
    }

    public void setSfrxm(String sfrxm) {
        this.sfrxm = sfrxm;
    }

    public String getSfrzh() {
        return sfrzh;
    }

    public void setSfrzh(String sfrzh) {
        this.sfrzh = sfrzh;
    }

    public String getSfrkhyh() {
        return sfrkhyh;
    }

    public void setSfrkhyh(String sfrkhyh) {
        this.sfrkhyh = sfrkhyh;
    }

    public String getSfdwdm() {
        return sfdwdm;
    }

    public void setSfdwdm(String sfdwdm) {
        this.sfdwdm = sfdwdm;
    }

    public Integer getSfzt() {
        return sfzt;
    }

    public void setSfzt(Integer sfzt) {
        this.sfzt = sfzt;
    }

    public String getSfztczrxm() {
        return sfztczrxm;
    }

    public void setSfztczrxm(String sfztczrxm) {
        this.sfztczrxm = sfztczrxm;
    }

    public Date getSfztczsj() {
        return sfztczsj;
    }

    public void setSfztczsj(Date sfztczsj) {
        this.sfztczsj = sfztczsj;
    }

    public String getFph() {
        return fph;
    }

    public void setFph(String fph) {
        this.fph = fph;
    }

    public String getCztxmbh() {
        return cztxmbh;
    }

    public void setCztxmbh(String cztxmbh) {
        this.cztxmbh = cztxmbh;
    }

    public String getFff() {
        return fff;
    }

    public void setFff(String fff) {
        this.fff = fff;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getSfrkhyhwddm() {
        return sfrkhyhwddm;
    }

    public void setSfrkhyhwddm(String sfrkhyhwddm) {
        this.sfrkhyhwddm = sfrkhyhwddm;
    }

    public String getKpfs() {
        return kpfs;
    }

    public void setKpfs(String kpfs) {
        this.kpfs = kpfs;
    }

    public String getJkfs() {
        return jkfs;
    }

    public void setJkfs(String jkfs) {
        this.jkfs = jkfs;
    }

    public String getQlrlb() {
        return qlrlb;
    }

    public void setQlrlb(String qlrlb) {
        this.qlrlb = qlrlb;
    }

    public String getJfsbm() {
        return jfsbm;
    }

    public void setJfsbm(String jfsbm) {
        this.jfsbm = jfsbm;
    }

    public String getJfsewmurl() {
        return jfsewmurl;
    }

    public void setJfsewmurl(String jfsewmurl) {
        this.jfsewmurl = jfsewmurl;
    }

    public String getYwr() {
        return ywr;
    }

    public void setYwr(String ywr) {
        this.ywr = ywr;
    }

    public Integer getBczt() {
        return bczt;
    }

    public void setBczt(Integer bczt) {
        this.bczt = bczt;
    }

    public String getTkdh() {
        return tkdh;
    }

    public void setTkdh(String tkdh) {
        this.tkdh = tkdh;
    }

    public String getJypzh() {
        return jypzh;
    }

    public void setJypzh(String jypzh) {
        this.jypzh = jypzh;
    }

    @Override
    public String toString() {
        return "BdcSlSfxxDO{" +
                "sfxxid='" + sfxxid + '\'' +
                ", jbxxid='" + jbxxid + '\'' +
                ", gzlslid='" + gzlslid + '\'' +
                ", xmid='" + xmid + '\'' +
                ", sfsj=" + sfsj +
                ", jedw='" + jedw + '\'' +
                ", hj=" + hj +
                ", bz='" + bz + '\'' +
                ", sfdcsr='" + sfdcsr + '\'' +
                ", sfdfsr='" + sfdfsr + '\'' +
                ", hsje=" + hsje +
                ", sfdwmc='" + sfdwmc + '\'' +
                ", jfrxm='" + jfrxm + '\'' +
                ", sfrxm='" + sfrxm + '\'' +
                ", sfrzh='" + sfrzh + '\'' +
                ", sfrkhyh='" + sfrkhyh + '\'' +
                ", sfdwdm='" + sfdwdm + '\'' +
                ", sfzt=" + sfzt +
                ", sfztczrxm='" + sfztczrxm + '\'' +
                ", sfztczsj=" + sfztczsj +
                ", fph='" + fph + '\'' +
                ", cztxmbh='" + cztxmbh + '\'' +
                ", fff='" + fff + '\'' +
                ", qlrlb='" + qlrlb + '\'' +
                ", sfrkhyhwddm='" + sfrkhyhwddm + '\'' +
                ", kpfs='" + kpfs + '\'' +
                ", kprxm='" + kprxm + '\'' +
                ", jkfs='" + jkfs + '\'' +
                ", jfsbm='" + jfsbm + '\'' +
                ", jfsewmurl='" + jfsewmurl + '\'' +
                ", ywr='" + ywr + '\'' +
                ", bczt=" + bczt +
                ", yhjkrkzt=" + yhjkrkzt +
                ", tkdh='" + tkdh + '\'' +
                ", jypzh='" + jypzh + '\'' +
                '}';
    }
}
