package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/10/31
 * @description 不动产受理收费项目
 */
@Table(name = "BDC_SL_SFXM")
@ApiModel(value = "BdcSlSfxmDO", description = "不动产受理收费项目")
public class BdcSlSfxmDO implements Serializable {
    private static final long serialVersionUID = 9057332373095716733L;
    @Id
    @ApiModelProperty(value = "收费项目ID")
    private String sfxmid;

    @ApiModelProperty(value = "收费单信息ID")
    private String sfxxid;

    @ApiModelProperty(value = "收费项目名称")
    private String sfxmmc;

    @ApiModelProperty(value = "收费项目代码")
    private String sfxmdm;

    @ApiModelProperty(value = "序号")
    private Integer xh;

    @ApiModelProperty(value = "数量")
    private Double sl;

    @ApiModelProperty(value = "减免金额")
    private Double jmje;

    @ApiModelProperty(value = "应收金额")
    private Double ysje;

    @ApiModelProperty(value = "实收金额")
    private Double ssje;

    @ApiModelProperty(value = "收费比例")
    private Double sfbl;

    @ApiModelProperty(value = "收费项目标准")
    private String sfxmbz;

    @ApiModelProperty(value = "金额单位")
    private String jedw;

    @ApiModelProperty(value = "计算方法")
    private String jsff;

    @ApiModelProperty(value = "缴费方式")
    private String jffs;

    @ApiModelProperty(value = "缴费终端")
    private String jfzd;

    @ApiModelProperty(value = "收费类型")
    private String sflx;

    @ApiModelProperty(value = "权利人类别")
    private String qlrlb;

    public String getSfxmid() {
        return sfxmid;
    }

    public void setSfxmid(String sfxmid) {
        this.sfxmid = sfxmid;
    }

    public String getSfxxid() {
        return sfxxid;
    }

    public void setSfxxid(String sfxxid) {
        this.sfxxid = sfxxid;
    }

    public String getSfxmmc() {
        return sfxmmc;
    }

    public void setSfxmmc(String sfxmmc) {
        this.sfxmmc = sfxmmc;
    }

    public String getSfxmdm() {
        return sfxmdm;
    }

    public void setSfxmdm(String sfxmdm) {
        this.sfxmdm = sfxmdm;
    }

    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    public Double getSl() {
        return sl;
    }

    public void setSl(Double sl) {
        this.sl = sl;
    }

    public Double getJmje() {
        return jmje;
    }

    public void setJmje(Double jmje) {
        this.jmje = jmje;
    }

    public Double getYsje() {
        return ysje;
    }

    public void setYsje(Double ysje) {
        this.ysje = ysje;
    }

    public Double getSsje() {
        return ssje;
    }

    public void setSsje(Double ssje) {
        this.ssje = ssje;
    }

    public Double getSfbl() {
        return sfbl;
    }

    public void setSfbl(Double sfbl) {
        this.sfbl = sfbl;
    }

    public String getSfxmbz() {
        return sfxmbz;
    }

    public void setSfxmbz(String sfxmbz) {
        this.sfxmbz = sfxmbz;
    }

    public String getJedw() {
        return jedw;
    }

    public void setJedw(String jedw) {
        this.jedw = jedw;
    }

    public String getJsff() {
        return jsff;
    }

    public void setJsff(String jsff) {
        this.jsff = jsff;
    }

    public String getJffs() {
        return jffs;
    }

    public void setJffs(String jffs) {
        this.jffs = jffs;
    }

    public String getJfzd() {
        return jfzd;
    }

    public void setJfzd(String jfzd) {
        this.jfzd = jfzd;
    }

    public String getSflx() {
        return sflx;
    }

    public void setSflx(String sflx) {
        this.sflx = sflx;
    }

    @Override
    public String toString() {
        return "BdcSlSfxmDO{" +
                "sfxmid='" + sfxmid + '\'' +
                ", sfxxid='" + sfxxid + '\'' +
                ", sfxmmc='" + sfxmmc + '\'' +
                ", sfxmdm='" + sfxmdm + '\'' +
                ", xh=" + xh +
                ", sl=" + sl +
                ", jmje=" + jmje +
                ", ysje=" + ysje +
                ", ssje=" + ssje +
                ", sfbl=" + sfbl +
                ", sfxmbz='" + sfxmbz + '\'' +
                ", jedw='" + jedw + '\'' +
                ", jsff='" + jsff + '\'' +
                ", jffs='" + jffs + '\'' +
                ", jfzd='" + jfzd + '\'' +
                ", sflx='" + sflx + '\'' +
                ", qlrlb='" + qlrlb + '\'' +
                '}';
    }

    public String getQlrlb() {
        return qlrlb;
    }

    public void setQlrlb(String qlrlb) {
        this.qlrlb = qlrlb;
    }
}
