package cn.gtmap.realestate.common.core.domain.accept;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/6/11
 * @description 不动产受理交易信息
 */
@Table(name = "BDC_SL_JYXX")
@ApiModel(value = "BdcSlJyxxDO", description = "不动产受理交易信息")
public class BdcSlJyxxDO implements Serializable {

    private static final long serialVersionUID = -4116218547300258499L;
    @Id
    @ApiModelProperty(value = "交易信息ID")
    private String jyxxid;

    @ApiModelProperty(value = "项目ID")
    private String xmid;

    @ApiModelProperty(value = "合同编号")
    private String htbh;

    @ApiModelProperty(value = "合同状态")
    private Integer htzt;

    @ApiModelProperty(value = "合同备案号")
    private String htbah;

    @ApiModelProperty(value = "单价")
    private Double dj;

    @ApiModelProperty(value = "合同登记时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date htdjsj;

    @ApiModelProperty(value = "合同备案时间")
    private Date htbasj;

    @ApiModelProperty(value = "交易类型")
    private Integer jylx;

    @ApiModelProperty(value = "合同面积")
    private Double htmj;

    @ApiModelProperty(value = "上次交易登记时间")
    private Date scjydjsj;

    @ApiModelProperty(value = "交易金额")
    private Double jyje;

    @ApiModelProperty(value = "付款方式")
    private String fkfs;

    @ApiModelProperty(value = "预售许可证号")
    private String ysxkzh;

    @ApiModelProperty(value = "规划许可证号")
    private String ghxkzh;

    @ApiModelProperty(value = "规划验收证明编号")
    private String ghyszmbh;

    @ApiModelProperty(value = "竣工验收备案编号")
    private String jgysbabh;

    @ApiModelProperty(value = "竣工验收备案时间")
    private Date jgysbasj;

    @ApiModelProperty(value = "规划验收日期")
    private Date ghyssj;

    @ApiModelProperty(value = "不含增值税金额")
    private Double bhzzsje;

    @ApiModelProperty(value = "增值税金额")
    private Double zzsje;

    @ApiModelProperty(value = "含增值税金额")
    private Double hzzsje;

    @ApiModelProperty(value = "房产证发证时间")
    private Date fczfzsj;

    @ApiModelProperty(value = "面积核定文件号")
    private String mjhdwjh;

    @ApiModelProperty(value = "项目名称")
    private String xmmc;
    
    @ApiModelProperty(value = "备注")
    private String bz;

    @ApiModelProperty(value =  "增值税减免")
    private Integer zzsjm;

    @ApiModelProperty(value = "发票交易价格")
    private Double fpjyjg;

    @ApiModelProperty(value = "交易发票号码")
    private String fphm;

    @ApiModelProperty(value = "交易发票代码")
    private String fpdm;

    public String getJyxxid() {
        return jyxxid;
    }

    public void setJyxxid(String jyxxid) {
        this.jyxxid = jyxxid;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getHtbh() {
        return htbh;
    }

    public void setHtbh(String htbh) {
        this.htbh = htbh;
    }

    public Integer getHtzt() {
        return htzt;
    }

    public void setHtzt(Integer htzt) {
        this.htzt = htzt;
    }

    public String getHtbah() {
        return htbah;
    }

    public void setHtbah(String htbah) {
        this.htbah = htbah;
    }

    public Double getDj() {
        return dj;
    }

    public void setDj(Double dj) {
        this.dj = dj;
    }

    public Date getHtdjsj() {
        return htdjsj;
    }

    public void setHtdjsj(Date htdjsj) {
        this.htdjsj = htdjsj;
    }

    public Date getHtbasj() {
        return htbasj;
    }

    public void setHtbasj(Date htbasj) {
        this.htbasj = htbasj;
    }

    public Integer getJylx() {
        return jylx;
    }

    public void setJylx(Integer jylx) {
        this.jylx = jylx;
    }

    public Double getHtmj() {
        return htmj;
    }

    public void setHtmj(Double htmj) {
        this.htmj = htmj;
    }

    public Date getScjydjsj() {
        return scjydjsj;
    }

    public void setScjydjsj(Date scjydjsj) {
        this.scjydjsj = scjydjsj;
    }

    public Double getJyje() {
        return jyje;
    }

    public void setJyje(Double jyje) {
        this.jyje = jyje;
    }

    public String getFkfs() {
        return fkfs;
    }

    public void setFkfs(String fkfs) {
        this.fkfs = fkfs;
    }

    public String getYsxkzh() {
        return ysxkzh;
    }

    public void setYsxkzh(String ysxkzh) {
        this.ysxkzh = ysxkzh;
    }

    public String getGhxkzh() {
        return ghxkzh;
    }

    public void setGhxkzh(String ghxkzh) {
        this.ghxkzh = ghxkzh;
    }

    public String getGhyszmbh() {
        return ghyszmbh;
    }

    public void setGhyszmbh(String ghyszmbh) {
        this.ghyszmbh = ghyszmbh;
    }

    public String getJgysbabh() {
        return jgysbabh;
    }

    public void setJgysbabh(String jgysbabh) {
        this.jgysbabh = jgysbabh;
    }

    public Date getJgysbasj() {
        return jgysbasj;
    }

    public void setJgysbasj(Date jgysbasj) {
        this.jgysbasj = jgysbasj;
    }

    public Date getGhyssj() {
        return ghyssj;
    }

    public void setGhyssj(Date ghyssj) {
        this.ghyssj = ghyssj;
    }

    public Double getBhzzsje() {
        return bhzzsje;
    }

    public void setBhzzsje(Double bhzzsje) {
        this.bhzzsje = bhzzsje;
    }

    public Double getZzsje() {
        return zzsje;
    }

    public void setZzsje(Double zzsje) {
        this.zzsje = zzsje;
    }

    public Date getFczfzsj() {
        return fczfzsj;
    }

    public void setFczfzsj(Date fczfzsj) {
        this.fczfzsj = fczfzsj;
    }

    public String getMjhdwjh() {
        return mjhdwjh;
    }

    public void setMjhdwjh(String mjhdwjh) {
        this.mjhdwjh = mjhdwjh;
    }

    public Double getHzzsje() {
        return hzzsje;
    }

    public void setHzzsje(Double hzzsje) {
        this.hzzsje = hzzsje;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Integer getZzsjm() {
        return zzsjm;
    }

    public void setZzsjm(Integer zzsjm) {
        this.zzsjm = zzsjm;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Double getFpjyjg() {
        return fpjyjg;
    }

    public void setFpjyjg(Double fpjyjg) {
        this.fpjyjg = fpjyjg;
    }

    public String getFphm() {
        return fphm;
    }

    public void setFphm(String fphm) {
        this.fphm = fphm;
    }

    public String getFpdm() {
        return fpdm;
    }

    public void setFpdm(String fpdm) {
        this.fpdm = fpdm;
    }

    @Override
    public String toString() {
        return "BdcSlJyxxDO{" +
                "jyxxid='" + jyxxid + '\'' +
                ", xmid='" + xmid + '\'' +
                ", htbh='" + htbh + '\'' +
                ", htzt=" + htzt +
                ", htbah='" + htbah + '\'' +
                ", dj=" + dj +
                ", htdjsj=" + htdjsj +
                ", htbasj=" + htbasj +
                ", jylx=" + jylx +
                ", htmj=" + htmj +
                ", scjydjsj=" + scjydjsj +
                ", jyje=" + jyje +
                ", fkfs='" + fkfs + '\'' +
                ", ysxkzh='" + ysxkzh + '\'' +
                ", ghxkzh='" + ghxkzh + '\'' +
                ", ghyszmbh='" + ghyszmbh + '\'' +
                ", jgysbabh='" + jgysbabh + '\'' +
                ", jgysbasj=" + jgysbasj +
                ", ghyssj=" + ghyssj +
                ", bhzzsje=" + bhzzsje +
                ", zzsje=" + zzsje +
                ", hzzsje=" + hzzsje +
                ", fczfzsj=" + fczfzsj +
                ", mjhdwjh='" + mjhdwjh + '\'' +
                ", xmmc='" + xmmc + '\'' +
                ", bz='" + bz + '\'' +
                ", zzsjm=" + zzsjm +
                ", fpjyjg=" + fpjyjg +
                ", fphm='" + fphm + '\'' +
                ", fpdm='" + fpdm + '\'' +
                '}';
    }
}
