package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/6/11
 * @description 不动产受理核税信息明细
 */
@Table(name = "BDC_SL_HSXX_MX")
@ApiModel(value = "BdcSlHsxxMxDO", description = "不动产受理核税信息明细")
public class BdcSlHsxxMxDO {

    @Id
    @ApiModelProperty(value = "核税信息明细ID")
    private String hsxxmxid;

    @ApiModelProperty(value = "核税信息ID")
    private String hsxxid;

    @ApiModelProperty(value = "明细种类")
    private String mxzl;

    @ApiModelProperty(value = "应纳税额")
    private Double ynse;

    @ApiModelProperty(value = "减免税额")
    private Double jmse;

    @ApiModelProperty(value = "实际纳税额")
    private Double sjnse;

    @ApiModelProperty(value = "顺序号")
    private Integer sxh;

    @ApiModelProperty(value = "纳税人名称")
    private String nsrmc;

    @ApiModelProperty(value = "征税项目")
    private String zsxm;

    @ApiModelProperty(value = "计税依据")
    private Double jsyj;

    @ApiModelProperty(value = "税率")
    private String sl;

    @ApiModelProperty(value = "拆迁补偿折算减免税款")
    private Double cqbczsjmsk;

    @ApiModelProperty(value = "增值税小规模纳税人减征比例")
    private String zzsxgmnsrjzbl;

    @ApiModelProperty(value = "增值税小规模纳税人减征额")
    private Double zzsxgmnsrjze;



    public String getHsxxmxid() {
        return hsxxmxid;
    }

    public void setHsxxmxid(String hsxxmxid) {
        this.hsxxmxid = hsxxmxid;
    }

    public String getHsxxid() {
        return hsxxid;
    }

    public void setHsxxid(String hsxxid) {
        this.hsxxid = hsxxid;
    }

    public String getMxzl() {
        return mxzl;
    }

    public void setMxzl(String mxzl) {
        this.mxzl = mxzl;
    }

    public Double getYnse() {
        return ynse;
    }

    public void setYnse(Double ynse) {
        this.ynse = ynse;
    }

    public Double getJmse() {
        return jmse;
    }

    public void setJmse(Double jmse) {
        this.jmse = jmse;
    }

    public Double getSjnse() {
        return sjnse;
    }

    public void setSjnse(Double sjnse) {
        this.sjnse = sjnse;
    }

    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    public String getNsrmc() {
        return nsrmc;
    }

    public void setNsrmc(String nsrmc) {
        this.nsrmc = nsrmc;
    }

    public String getZsxm() {
        return zsxm;
    }

    public void setZsxm(String zsxm) {
        this.zsxm = zsxm;
    }

    public Double getJsyj() {
        return jsyj;
    }

    public void setJsyj(Double jsyj) {
        this.jsyj = jsyj;
    }

    public String getSl() {
        return sl;
    }

    public void setSl(String sl) {
        this.sl = sl;
    }

    public Double getCqbczsjmsk() {
        return cqbczsjmsk;
    }

    public void setCqbczsjmsk(Double cqbczsjmsk) {
        this.cqbczsjmsk = cqbczsjmsk;
    }

    public String getZzsxgmnsrjzbl() {
        return zzsxgmnsrjzbl;
    }

    public void setZzsxgmnsrjzbl(String zzsxgmnsrjzbl) {
        this.zzsxgmnsrjzbl = zzsxgmnsrjzbl;
    }

    public Double getZzsxgmnsrjze() {
        return zzsxgmnsrjze;
    }

    public void setZzsxgmnsrjze(Double zzsxgmnsrjze) {
        this.zzsxgmnsrjze = zzsxgmnsrjze;
    }

    @Override
    public String toString() {
        return "BdcSlHsxxMxDO{" +
                "hsxxmxid='" + hsxxmxid + '\'' +
                ", hsxxid='" + hsxxid + '\'' +
                ", mxzl='" + mxzl + '\'' +
                ", ynse=" + ynse +
                ", jmse=" + jmse +
                ", sjnse=" + sjnse +
                ", sxh=" + sxh +
                ", nsrmc='" + nsrmc + '\'' +
                ", zsxm='" + zsxm + '\'' +
                ", jsyj=" + jsyj +
                ", sl='" + sl + '\'' +
                ", cqbczsjmsk=" + cqbczsjmsk +
                ", zzsxgmnsrjzbl='" + zzsxgmnsrjzbl + '\'' +
                ", zzsxgmnsrjze=" + zzsxgmnsrjze +
                '}';
    }
}
