package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/13
 * @description 不动产登记小类配置
 */
@Table(name = "BDC_DJXL_PZ")
@ApiModel(value = "BdcDjxlPzDO", description = "不动产登记小类配置")
public class BdcDjxlPzDO implements Serializable, Comparable<BdcDjxlPzDO> {

    @Id
    @ApiModelProperty(value = "配置ID")
    private String pzid;
    @ApiModelProperty(value = "登记小类")
    private String djxl;
    @ApiModelProperty(value = "工作流定义ID")
    private String gzldyid;
    @ApiModelProperty(value = "权利类型")
    private Integer qllx;
    @ApiModelProperty(value = "顺序号")
    private Integer sxh;
    @ApiModelProperty(value = "不动产类型")
    private Integer bdclx;
    @ApiModelProperty(value = "根据不动产单元号判断的权利类型")
    private Integer dyhqllx;
    @ApiModelProperty(value = "是否收费")
    private Integer sfsf;
    @ApiModelProperty(value = "申请书打印类型")
    private String sqsdylx;
    @ApiModelProperty(value = "审批表打印类型")
    private String spbdylx;
    @ApiModelProperty(value = "配置修改时间")
    private Date pzxgsj;

    @Override
    public String toString() {
        return "BdcDjxlPzDO{" +
                "pzid='" + pzid + '\'' +
                ", djxl='" + djxl + '\'' +
                ", gzldyid='" + gzldyid + '\'' +
                ", qllx=" + qllx +
                ", sxh=" + sxh +
                ", bdclx=" + bdclx +
                ", dyhqllx=" + dyhqllx +
                ", sfsf=" + sfsf +
                ", sqsdylx='" + sqsdylx + '\'' +
                ", spbdylx='" + spbdylx + '\'' +
                ", pzxgsj=" + pzxgsj +
                '}';
    }

    public String getPzid() {
        return pzid;
    }

    public void setPzid(String pzid) {
        this.pzid = pzid;
    }

    public String getDjxl() {
        return djxl;
    }

    public void setDjxl(String djxl) {
        this.djxl = djxl;
    }

    public String getGzldyid() {
        return gzldyid;
    }

    public void setGzldyid(String gzldyid) {
        this.gzldyid = gzldyid;
    }

    public Integer getQllx() {
        return qllx;
    }

    public void setQllx(Integer qllx) {
        this.qllx = qllx;
    }

    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    public BdcDjxlPzDO() {
        super();
    }

    public BdcDjxlPzDO(String pzid, String djxl, String gzldyid, Integer qllx, Integer sxh, Integer bdclx) {
        this.pzid = pzid;
        this.djxl = djxl;
        this.gzldyid = gzldyid;
        this.qllx = qllx;
        this.sxh = sxh;
        this.bdclx = bdclx;
    }

    @Override
    public int compareTo(BdcDjxlPzDO o) {
        return this.sxh.compareTo(o.getSxh());
    }

    public Integer getBdclx() {
        return bdclx;
    }

    public void setBdclx(Integer bdclx) {
        this.bdclx = bdclx;
    }

    public Integer getDyhqllx() {
        return dyhqllx;
    }

    public void setDyhqllx(Integer dyhqllx) {
        this.dyhqllx = dyhqllx;
    }

    public Integer getSfsf() {
        return sfsf;
    }

    public void setSfsf(Integer sfsf) {
        this.sfsf = sfsf;
    }

    public String getSqsdylx() {
        return sqsdylx;
    }

    public void setSqsdylx(String sqsdylx) {
        this.sqsdylx = sqsdylx;
    }

    public String getSpbdylx() {
        return spbdylx;
    }

    public void setSpbdylx(String spbdylx) {
        this.spbdylx = spbdylx;
    }

    public Date getPzxgsj() {
        return pzxgsj;
    }

    public void setPzxgsj(Date pzxgsj) {
        this.pzxgsj = pzxgsj;
    }
}
