package cn.gtmap.realestate.common.core.domain;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2018/12/10
 * @description  不动产证号实体（预留证号、废号）公共属性定义实体
 */
public class BdcZhDO {
    @ApiModelProperty(value = "不动产权证号")
    private String bdcqzh;

    @ApiModelProperty(value = "证号流水号")
    private String zhlsh;

    @ApiModelProperty(value = "证号序列号")
    private Integer zhxlh;

    @ApiModelProperty(value = "年份")
    private String nf;

    @ApiModelProperty(value = "证书类型")
    private Integer zslx;

    @ApiModelProperty(value = "省区市简称")
    private String sqsjc;

    @ApiModelProperty(value = "所在市县全称")
    private String szsxqc;

    @ApiModelProperty(value = "使用情况")
    private Integer syqk;

    @ApiModelProperty(value = "区县代码")
    private String qxdm;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "生成日期", example = "2018-10-01 12:18:48")
    private Date scrq;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期", example = "2018-10-01 12:18:48")
    private Date gxrq;


    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getZhlsh() {
        return zhlsh;
    }

    public void setZhlsh(String zhlsh) {
        this.zhlsh = zhlsh;
    }

    public String getNf() {
        return nf;
    }

    public void setNf(String nf) {
        this.nf = nf;
    }

    public Integer getZslx() {
        return zslx;
    }

    public void setZslx(Integer zslx) {
        this.zslx = zslx;
    }

    public String getSqsjc() {
        return sqsjc;
    }

    public void setSqsjc(String sqsjc) {
        this.sqsjc = sqsjc;
    }

    public String getSzsxqc() {
        return szsxqc;
    }

    public void setSzsxqc(String szsxqc) {
        this.szsxqc = szsxqc;
    }

    public Integer getSyqk() {
        return syqk;
    }

    public void setSyqk(Integer syqk) {
        this.syqk = syqk;
    }

    public Date getScrq() {
        return scrq;
    }

    public void setScrq(Date scrq) {
        this.scrq = scrq;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }

    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public Integer getZhxlh() {
        return zhxlh;
    }

    public void setZhxlh(Integer zhxlh) {
        this.zhxlh = zhxlh;
    }

    @Override
    public String toString() {
        return "BdcZhDO{" +
                "bdcqzh='" + bdcqzh + '\'' +
                ", zhlsh='" + zhlsh + '\'' +
                ", zhxlh=" + zhxlh +
                ", nf='" + nf + '\'' +
                ", zslx=" + zslx +
                ", sqsjc='" + sqsjc + '\'' +
                ", szsxqc='" + szsxqc + '\'' +
                ", syqk=" + syqk +
                ", qxdm='" + qxdm + '\'' +
                ", scrq=" + scrq +
                ", gxrq=" + gxrq +
                '}';
    }
}
