package cn.gtmap.realestate.common.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
 /**
  * @author <a href="mailto:songjiawei@gtmap.cn">songjiawei</a>
  * @description 房地产权（项目内多幢）项目信息
  */
@Table(
        name = "BDC_FDCQ_FDCQXM"
)
@ApiModel(value = "BdcFdcqFdcqxmDO", description = "不动产房地产权（项目内多幢）项目信息")
public class BdcFdcqFdcqxmDO {
    @Id
    @ApiModelProperty(value = "分幢ID")
    private String fzid;
     @ApiModelProperty(value = "权利ID")
    private String qlid;
     @ApiModelProperty(value = "项目名称")
    private String xmmc;
     @ApiModelProperty(value = "幢号")
    private String zh;
     @ApiModelProperty(value = "总层数")
    private Integer zcs;
     @ApiModelProperty(value = "规划用途")
    private Integer ghyt;
     @ApiModelProperty(value = "房屋结构")
    private Integer fwjg;
     @ApiModelProperty(value = "建筑面积")
    private Double jzmj;
     @ApiModelProperty(value = "竣工时间",example = "2018-10-01")
    private String jgsj;
     @ApiModelProperty(value = "总套数")
    private Integer zts;
     @ApiModelProperty(value = "房屋性质")
    private Integer fwxz;
     @ApiModelProperty(value = "幢占地面积")
    private Double zzdmj;
     @ApiModelProperty(value = "不动产单元编号")
    private String bdcdywybh;
     @ApiModelProperty(value = "建筑年代")
    private Double jznd;

    public String getFzid() {
        return fzid;
    }

    public void setFzid(String fzid) {
        this.fzid = fzid;
    }

    public String getQlid() {
        return qlid;
    }

    public void setQlid(String qlid) {
        this.qlid = qlid;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }

     public Integer getZcs() {
         return zcs;
     }

     public void setZcs(Integer zcs) {
         this.zcs = zcs;
     }

     public Integer getGhyt() {
        return ghyt;
    }

    public void setGhyt(Integer ghyt) {
        this.ghyt = ghyt;
    }

    public Integer getFwjg() {
        return fwjg;
    }

    public void setFwjg(Integer fwjg) {
        this.fwjg = fwjg;
    }

    public Double getJzmj() {
        return jzmj;
    }

    public void setJzmj(Double jzmj) {
        this.jzmj = jzmj;
    }

     @Override
     public String toString() {
         return "BdcFdcqFdcqxmDO{" +
                 "fzid='" + fzid + '\'' +
                 ", qlid='" + qlid + '\'' +
                 ", xmmc='" + xmmc + '\'' +
                 ", zh='" + zh + '\'' +
                 ", zcs=" + zcs +
                 ", ghyt=" + ghyt +
                 ", fwjg=" + fwjg +
                 ", jzmj=" + jzmj +
                 ", jgsj='" + jgsj + '\'' +
                 ", zts=" + zts +
                 ", fwxz=" + fwxz +
                 ", zzdmj=" + zzdmj +
                 ", bdcdywybh='" + bdcdywybh + '\'' +
                 ", jznd=" + jznd +
                 '}';
     }

     public String getJgsj() {
         return jgsj;
     }

     public void setJgsj(String jgsj) {
         this.jgsj = jgsj;
     }

     public Integer getZts() {
         return zts;
     }

     public void setZts(Integer zts) {
         this.zts = zts;
     }

     public Integer getFwxz() {
        return fwxz;
    }

    public void setFwxz(Integer fwxz) {
        this.fwxz = fwxz;
    }

    public Double getZzdmj() {
        return zzdmj;
    }

    public void setZzdmj(Double zzdmj) {
        this.zzdmj = zzdmj;
    }

     public String getBdcdywybh() {
         return bdcdywybh;
     }

     public void setBdcdywybh(String bdcdywybh) {
         this.bdcdywybh = bdcdywybh;
     }

     public Double getJznd() {
        return jznd;
    }

    public void setJznd(Double jznd) {
        this.jznd = jznd;
    }

 }
