package cn.gtmap.realestate.common.core.annotations;
import java.lang.annotation.*;

/**
 * version 1.0
 * @description 日志注解
 * @date 2019/6/3
 * @author <a href ="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface LogCommonEvent {

    /** 日志动作，查询，导出等*/
    String event() default "";

    /** 日志参数*/
    String[] names() default {};

    /** 日志台账类型*/
    String viewType() default "";

    /** 日志模块代码*/
    String modelDm() default "";

    /** 日志模块名称*/
    String modelMc() default "";

    /** 是否记录返回结果，默认false,不记录*/
    boolean response() default false;
}
