package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.core.dto.register.DbLogDTO;
import cn.gtmap.realestate.common.core.enums.LogKeyEnum;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2019/9/28
 * @description 手动登簿LOG日志
 */
@Component
public class DbLogUtils {

    @Autowired
    private UserManagerUtils userManagerUtils;

    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;

    private static final Logger LOGGER = LoggerFactory.getLogger(DbLogUtils.class);


    /**
     * @param dbLogDTO 登簿参数
     * @return saveDbLog
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 保存登簿验证日志
     */
    public void saveDbLog(DbLogDTO dbLogDTO) {

        Map<String, Object> data = new HashMap();
        String userName = userManagerUtils.getCurrentUserName();
        UserDto userDto = userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            // 有的用户被删除，需要判空
            data.put(CommonConstantUtils.ALIAS, userDto.getAlias());
        }
        data.put(LogKeyEnum.EVENT_NAME.getKey(), "手动登簿操作日志");
        if (dbLogDTO.getPrivateAttrMap() != null) {
            data.putAll(dbLogDTO.getPrivateAttrMap());
        }
        AuditEvent auditEvent = new AuditEvent(userName, CommonConstantUtils.LOG_EVENT_SDDBLOG, data);
        try {
            zipkinAuditEventRepository.add(auditEvent);
        } catch (Exception e) {
            LOGGER.error("-------日志记录接口出错-------" + e.getMessage());
        }
    }

    /**
     * @param routeKey 队列和交换机绑定的Key
     * @param exchange Exchange名称
     * @param obj      发送的数据
     * @return
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 登簿Mq发送日志记录
     */
    public void saveMqSendLog(String exchange, String routeKey, Object obj) {
        LOGGER.warn("登簿Mq发送日志记录saveMqSendLog,exchange:{},routeKey:{},obj{}", exchange, routeKey, obj);
        Map<String, Object> data = new HashMap();
        String userName = userManagerUtils.getCurrentUserName();
        UserDto userDto = userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            // 有的用户被删除，需要判空
            data.put(CommonConstantUtils.ALIAS, userDto.getAlias());
        }
        data.put(LogKeyEnum.EVENT_NAME.getKey(), "登簿Mq发送操作日志");
        data.put("exchange", exchange);
        data.put("routeKey", routeKey);
        data.put("sendData", obj);
        AuditEvent auditEvent = new AuditEvent(userName, CommonConstantUtils.LOG_EVENT_SDDBLOG, data);
        try {
            zipkinAuditEventRepository.add(auditEvent);
        } catch (Exception e) {
            LOGGER.error("-------日志记录接口出错-------" + e.getMessage());
        }
    }
}
