--liquibase formatted sql
--preconditions dbms:oracle
--changeset BDC_SL_XZTZ_PZ:1 failOnError:false runOnChange:true runAlways:false
create table BDC_SL_XZTZ_PZ
(
  PZID      VARCHAR2(32),
  GZLDYID   VARCHAR2(32),
  XZTZLX    VARCHAR2(50),
  QLLX      VARCHAR2(50),
  ZDTZM     VARCHAR2(50),
  DZWTZM    VARCHAR2(50),
  BDCDYFWLX VARCHAR2(50),
  DYHCXLX   NUMBER(1)
)
tablespace BDCSL
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 128K
    next 1M
    minextents 1
    maxextents unlimited
  );
comment on table BDC_SL_XZTZ_PZ
  is '不动产受理选择台账配置';
comment on column BDC_SL_XZTZ_PZ.PZID
  is '配置ID';
comment on column BDC_SL_XZTZ_PZ.GZLDYID
  is '工作流定义ID';
comment on column BDC_SL_XZTZ_PZ.XZTZLX
  is '选择台账类型(1:不动产单元信息 2:产权证 3:查封 4:逻辑幢)';
comment on column BDC_SL_XZTZ_PZ.QLLX
  is '权利类型';
comment on column BDC_SL_XZTZ_PZ.ZDTZM
  is '宗地特征码';
comment on column BDC_SL_XZTZ_PZ.DZWTZM
  is '定作物特征码';
comment on column BDC_SL_XZTZ_PZ.BDCDYFWLX
  is '不动产单元房屋类型';
comment on column BDC_SL_XZTZ_PZ.DYHCXLX
  is '单元号查询类型（选择不动产单元号table使用）（1:土地及其定作物类型不动产单元信息  2:海域及其定作物类型不动产单元信息 3:构筑物不动产单元信息）';
