--liquibase formatted sql
--preconditions dbms:oracle
--changeset BDC_SL_XM:1 failOnError:false runOnChange:true runAlways:false

create table BDC_SL_XM
(
  xmid       VARCHAR2(32) not null,
  jbxxid     VARCHAR2(32) not null,
  bdcdyh     VARCHAR2(28) not null,
  qjid       VARCHAR2(50),
  bdclx      NUMBER,
  djxl       VARCHAR2(10),
  sfxxid     VARCHAR2(32),
  ybdcqz     VARCHAR2(100),
  jejg       NUMBER(15,6),
  dyje       NUMBER(15,6),
  dyfs       NUMBER,
  zwlxqssj   DATE,
  zwlxjssj   DATE,
  zjjzwzl    VARCHAR2(100),
  zjjzwdyfw  VARCHAR2(200),
  zgzqqdss   VARCHAR2(1000),
  dbfw       VARCHAR2(100),
  dkfs       VARCHAR2(100),
  bdbzzqse   NUMBER(15,6),
  fwpgjg     NUMBER(15,4),
  tdpgjg     NUMBER(15,4),
  cfjg       VARCHAR2(100),
  cflx       NUMBER,
  cfwh       VARCHAR2(200),
  cffw       VARCHAR2(200),
  cfqssj     DATE,
  cfjssj     DATE,
  zxsqr      VARCHAR2(200),
  bzxr       VARCHAR2(200),
  cfyy       VARCHAR2(500),
  lhcfqx     VARCHAR2(100),
  fysdr      VARCHAR2(100),
  ygdjzl     NUMBER,
  qdjg       NUMBER(15,4),
  gyqk       VARCHAR2(500),
  ygzwlxqssj DATE,
  ygzwlxjssj DATE,
  ygdyfs     NUMBER,
  yysx       VARCHAR2(200),
  syqmj      NUMBER(15,4),
  ldsyksqx   DATE,
  ldsyjsqx   DATE,
  ldsyqxz    NUMBER,
  sllmsyqr1  VARCHAR2(100),
  sllmsyqr2  VARCHAR2(100),
  zysz       VARCHAR2(100),
  zs         NUMBER(10),
  lz         NUMBER,
  qy         NUMBER,
  zlnd       NUMBER(4),
  xdm        VARCHAR2(100),
  lb         VARCHAR2(100),
  xb         VARCHAR2(100),
  qlrsjly    NUMBER,
  ywrsjly    NUMBER,
  sfscql     NUMBER,
  qlsjly     VARCHAR2(10),
  zszl       NUMBER,
  zsxh       NUMBER,
  zdzhyt     NUMBER,
  xdyzl      VARCHAR2(100),
  xdybdcdyh  VARCHAR2(28),
  zdzhmj     NUMBER(15,4),
  zl         VARCHAR2(500),
  qlr        VARCHAR2(100),
  sfzlcsh    NUMBER(1),
  bdcdyfwlx  NUMBER(1),
  czrid      VARCHAR2(100),
  czsj       DATE,
  sfzf       NUMBER(1),
  sfhyyzxql       NUMBER(1),
  sfhz       NUMBER(1)
)
tablespace BDCSL
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16K
    next 8K
    minextents 1
    maxextents unlimited
  );
comment on table BDC_SL_XM
  is '不动产受理项目';
comment on column BDC_SL_XM.xmid
  is '项目ID
';
comment on column BDC_SL_XM.jbxxid
  is '基本信息ID
';
comment on column BDC_SL_XM.bdcdyh
  is '不动产单元号
';
comment on column BDC_SL_XM.qjid
  is '权籍ID
';
comment on column BDC_SL_XM.bdclx
  is '不动产类型
';
comment on column BDC_SL_XM.djxl
  is '登记小类';
comment on column BDC_SL_XM.sfxxid
  is '收费信息id
';
comment on column BDC_SL_XM.ybdcqz
  is '原不动产权证
';
comment on column BDC_SL_XM.jejg
  is '交易价格
';
comment on column BDC_SL_XM.dyje
  is '抵押金额
';
comment on column BDC_SL_XM.dyfs
  is '抵押方式
';
comment on column BDC_SL_XM.zwlxqssj
  is '债务履行起始时间
';
comment on column BDC_SL_XM.zwlxjssj
  is '债务履行结束时间
';
comment on column BDC_SL_XM.zjjzwzl
  is '在建建筑物坐落
';
comment on column BDC_SL_XM.zjjzwdyfw
  is '在建建筑物抵押范围
';
comment on column BDC_SL_XM.zgzqqdss
  is '最高债权确定事实
';
comment on column BDC_SL_XM.dbfw
  is '担保范围
';
comment on column BDC_SL_XM.dkfs
  is '贷款方式
';
comment on column BDC_SL_XM.bdbzzqse
  is '被担保主债权数额
';
comment on column BDC_SL_XM.fwpgjg
  is '房屋评估价格
';
comment on column BDC_SL_XM.tdpgjg
  is '土地评估价格
';
comment on column BDC_SL_XM.cfjg
  is '查封机关
';
comment on column BDC_SL_XM.cflx
  is '查封类型
';
comment on column BDC_SL_XM.cfwh
  is '查封文号
';
comment on column BDC_SL_XM.cffw
  is '查封范围
';
comment on column BDC_SL_XM.cfqssj
  is '查封起始时间
';
comment on column BDC_SL_XM.cfjssj
  is '查封结束时间
';
comment on column BDC_SL_XM.zxsqr
  is '执行申请人
';
comment on column BDC_SL_XM.bzxr
  is '被执行人
';
comment on column BDC_SL_XM.cfyy
  is '查封原因
';
comment on column BDC_SL_XM.lhcfqx
  is '轮候查封期限
';
comment on column BDC_SL_XM.fysdr
  is '法院送达人
';
comment on column BDC_SL_XM.ygdjzl
  is '预告登记种类
';
comment on column BDC_SL_XM.qdjg
  is '取得价格/主债权数额
';
comment on column BDC_SL_XM.gyqk
  is '共有情况
';
comment on column BDC_SL_XM.ygzwlxqssj
  is '预告债务履行起始时间
';
comment on column BDC_SL_XM.ygzwlxjssj
  is '预告债务履行结束时间
';
comment on column BDC_SL_XM.ygdyfs
  is '预告抵押方式
';
comment on column BDC_SL_XM.yysx
  is '异议事项
';
comment on column BDC_SL_XM.syqmj
  is '使用权（承包方）面积
';
comment on column BDC_SL_XM.ldsyksqx
  is '林地使用（承包）开始期限
';
comment on column BDC_SL_XM.ldsyjsqx
  is '林地使用（承包）结束期限
';
comment on column BDC_SL_XM.ldsyqxz
  is '林地所有权性质
';
comment on column BDC_SL_XM.sllmsyqr1
  is '森林、林木所有权人
';
comment on column BDC_SL_XM.sllmsyqr2
  is '森林、林木使用权人
';
comment on column BDC_SL_XM.zysz
  is '主要树种
';
comment on column BDC_SL_XM.zs
  is '株数
';
comment on column BDC_SL_XM.lz
  is '林种
';
comment on column BDC_SL_XM.qy
  is '起源
';
comment on column BDC_SL_XM.zlnd
  is '造林年度
';
comment on column BDC_SL_XM.xdm
  is '小地名
';
comment on column BDC_SL_XM.lb
  is '林班
';
comment on column BDC_SL_XM.xb
  is '小班
';
comment on column BDC_SL_XM.qlrsjly
  is '权利人数据来源 1：权籍 2：上一手权利人 3：上一手义务人';
comment on column BDC_SL_XM.ywrsjly
  is '义务人数据来源 1：权籍 2：上一手权利人 3：上一手义务人';
comment on column BDC_SL_XM.sfscql
  is '是否生成权利 0：否  1：是';
comment on column BDC_SL_XM.qlsjly
  is '权利数据来源 1：权籍 2：上一手  可组合(1,2)*/';
comment on column BDC_SL_XM.zszl
  is '证书种类   1：证书  2：证明';
comment on column BDC_SL_XM.zsxh
  is '证书序号：用于组合发证 分组';
comment on column BDC_SL_XM.zdzhyt
  is '宗地宗海用途';
comment on column BDC_SL_XM.xdyzl
  is '需地役坐落';
comment on column BDC_SL_XM.xdybdcdyh
  is '需地役不动产单元号';
comment on column BDC_SL_XM.zdzhmj
  is '宗地宗海面积';
comment on column BDC_SL_XM.zl
  is '坐落';
comment on column BDC_SL_XM.qlr
  is '权利人';
comment on column BDC_SL_XM.sfzlcsh
  is '是否增量初始化 0：否  1：是';
comment on column BDC_SL_XM.bdcdyfwlx
  is '不动产单元房屋类型';
comment on column BDC_SL_XM.czrid
  is '操作人ID';
comment on column BDC_SL_XM.czsj
  is '操作时间';
comment on column BDC_SL_XM.sfzf
  is '是否主房  0：否  1：是';
comment on column BDC_SL_XM.sfhyyzxql
  is '是否还原原注销权利  0：否  1：是';
comment on column BDC_SL_XM.sfhz
  is '是否换证  0：否  1：是';
alter table BDC_SL_XM
  add constraint PK_BDC_SL_XM primary key (XMID)
  using index
  tablespace BDCSL
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 6M
    next 1M
    minextents 1
    maxextents unlimited
  );


--changeset BDC_SL_XM:2 failOnError:false runOnChange:true runAlways:false
ALTER TABLE BDC_SL_XM ADD(SFHZ  NUMBER(1));
COMMENT ON COLUMN BDC_SL_XM.SFHZ IS '是否换证  0：否  1：是';
ALTER TABLE BDC_SL_XM ADD(SFHYYZXQL  NUMBER(1));
COMMENT ON COLUMN BDC_SL_XM.SFHYYZXQL IS '是否还原原注销权利  0：否  1：是';