--liquibase formatted sql
--preconditions dbms:oracle
--changeset BDC_SL_SQR:1 failOnError:false runOnChange:true runAlways:false

create table BDC_SL_SQR
(
  sqrid VARCHAR2(32) not null,
  xmid  VARCHAR2(32) not null,
  sqrmc VARCHAR2(200),
  zjzl  NUMBER,
  zjh   VARCHAR2(100),
  txdz  VARCHAR2(200),
  yb    VARCHAR2(100),
  xb    NUMBER,
  frmc  VARCHAR2(100),
  frdh  VARCHAR2(100),
  dlrmc VARCHAR2(100),
  dlrdh VARCHAR2(100),
  dljg  VARCHAR2(100),
  sqrlx NUMBER,
  sqrlb VARCHAR2(2),
  qlbl  NUMBER(10,4),
  qlbl2 VARCHAR2(50),
  gyfs  NUMBER,
  gyqk  VARCHAR2(1000),
  dh    VARCHAR2(100),
  sshy  VARCHAR2(100),
  bz    VARCHAR2(2000),
  sfczr NUMBER,
  sxh   NUMBER
)
tablespace BDCSL
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16K
    next 8K
    minextents 1
    maxextents unlimited
  );
comment on table BDC_SL_SQR
  is '不动产受理申请人';
comment on column BDC_SL_SQR.sqrid
  is '申请人人ID
';
comment on column BDC_SL_SQR.xmid
  is '项目ID';
comment on column BDC_SL_SQR.sqrmc
  is '申请人名称';
comment on column BDC_SL_SQR.zjzl
  is '证件种类';
comment on column BDC_SL_SQR.zjh
  is '证件号';
comment on column BDC_SL_SQR.txdz
  is '通讯地址';
comment on column BDC_SL_SQR.yb
  is '邮编';
comment on column BDC_SL_SQR.xb
  is '性别';
comment on column BDC_SL_SQR.frmc
  is '法人名称';
comment on column BDC_SL_SQR.frdh
  is '法人电话';
comment on column BDC_SL_SQR.dlrmc
  is '代理人名称';
comment on column BDC_SL_SQR.dlrdh
  is '代理人电话';
comment on column BDC_SL_SQR.dljg
  is '代理机构';
comment on column BDC_SL_SQR.sqrlx
  is '申请人类型';
comment on column BDC_SL_SQR.sqrlb
  is '申请人类别(1-权利人；2-义务人)';
comment on column BDC_SL_SQR.qlbl
  is '权利比例(数值型权利比例)';
comment on column BDC_SL_SQR.qlbl2
  is '权利比例2(分数或文字型权利比例)';
comment on column BDC_SL_SQR.gyfs
  is '共有方式';
comment on column BDC_SL_SQR.gyqk
  is '共有情况';
comment on column BDC_SL_SQR.dh
  is '电话';
comment on column BDC_SL_SQR.sshy
  is '所属行业';
comment on column BDC_SL_SQR.bz
  is '备注';
comment on column BDC_SL_SQR.sfczr
  is '是否持证人';
comment on column BDC_SL_SQR.sxh
  is '顺序号';
alter table BDC_SL_SQR
  add constraint PK_BDC_SL_SQR primary key (SQRID)
  using index
  tablespace BDCSL
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
