--liquibase formatted sql
--preconditions dbms:oracle
--changeset BDC_SL_SFXX:1 failOnError:false runOnChange:true runAlways:false

create table BDC_SL_SFXX
(
  sfxxid    VARCHAR2(32) not null,
  jbxxid    VARCHAR2(32) not null,
  sfsj      DATE,
  jedw      NUMBER,
  hj        NUMBER(12,4),
  bz        VARCHAR2(1000),
  sfdcsr    VARCHAR2(50),
  sfdfsr    VARCHAR2(50),
  hsje      NUMBER(12,4),
  sfdwmc    VARCHAR2(500),
  jfrxm     VARCHAR2(100),
  sfrxm     VARCHAR2(100),
  sfrzh     VARCHAR2(100),
  sfrkhyh   VARCHAR2(100),
  sfdwdm    VARCHAR2(100),
  sfzt      NUMBER,
  sfztczrxm VARCHAR2(100),
  sfztczsj  DATE,
  fph       VARCHAR2(100),
  cztxmbh   VARCHAR2(100),
  fff       NUMBER
)
tablespace BDCSL
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16K
    next 8K
    minextents 1
    maxextents unlimited
  );
comment on table BDC_SL_SFXX
  is '不动产受理收费信息';
comment on column BDC_SL_SFXX.sfxxid
  is '收费信息id';
comment on column BDC_SL_SFXX.jbxxid
  is '基本信息ID';
comment on column BDC_SL_SFXX.sfsj
  is '收费时间';
comment on column BDC_SL_SFXX.jedw
  is '金额单位';
comment on column BDC_SL_SFXX.hj
  is '合计单位：元';
comment on column BDC_SL_SFXX.bz
  is '备注';
comment on column BDC_SL_SFXX.sfdcsr
  is '收费单初审人';
comment on column BDC_SL_SFXX.sfdfsr
  is '收费单复审人';
comment on column BDC_SL_SFXX.hsje
  is '核收金额(单位：元)';
comment on column BDC_SL_SFXX.sfdwmc
  is '收费单位名称(收费机构)';
comment on column BDC_SL_SFXX.jfrxm
  is '缴费人姓名';
comment on column BDC_SL_SFXX.sfrxm
  is '收费人姓名';
comment on column BDC_SL_SFXX.sfrzh
  is '收费人账号';
comment on column BDC_SL_SFXX.sfrkhyh
  is '收费人开户银行';
comment on column BDC_SL_SFXX.sfdwdm
  is '收费单位代码';
comment on column BDC_SL_SFXX.sfzt
  is '收费状态';
comment on column BDC_SL_SFXX.sfztczrxm
  is '收费状态操作人姓名';
comment on column BDC_SL_SFXX.sfztczsj
  is '收费状态操作时间';
comment on column BDC_SL_SFXX.fph
  is '发票号';
comment on column BDC_SL_SFXX.cztxmbh
  is '财政条形码编号';
comment on column BDC_SL_SFXX.fff
  is '付费方';
alter table BDC_SL_SFXX
  add constraint PK_BDC_SL_SFXX primary key (SFXXID)
  using index
  tablespace BDCSL
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
