--liquibase formatted sql
--preconditions dbms:oracle
--changeset BDC_LSH:1 failOnError:false runOnChange:true runAlways:false
create table BDC_DJXL_PZ
(
  pzid    VARCHAR2(32) not null,
  djxl    VARCHAR2(20) not null,
  gzldyid VARCHAR2(32) not null
)
tablespace BDCSL
  pctfree 10
  initrans 1
  maxtrans 255;
-- Add comments to the table
comment on table BDC_DJXL_PZ
  is '不动产登记小类配置';
-- Add comments to the columns
comment on column BDC_DJXL_PZ.pzid
  is '配置ID';
comment on column BDC_DJXL_PZ.djxl
  is '登记小类';
comment on column BDC_DJXL_PZ.gzldyid
  is '工作流定义ID';
-- Create/Recreate primary, unique and foreign key constraints
alter table BDC_DJXL_PZ
  add constraint PK_BDCDJXLPZ primary key (PZID)
  using index
  tablespace BDCSL
  pctfree 10
  initrans 2
  maxtrans 255;
