/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.service.impl;

import cn.gtmap.realestate.accept.core.mapper.BdcLshMapper;
import cn.gtmap.realestate.accept.service.BdcBhService;
import cn.gtmap.realestate.accept.util.CommonUtil;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcBhServiceImpl
implements BdcBhService {
    private static final FastDateFormat MONTH_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyyMM");
    private static final FastDateFormat YEAR_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy");
    public static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    @Autowired
    private BdcLshMapper bdcLshMapper;

    public synchronized Integer queryLsh(String ywlx, String zzsjfw) {
        Integer maxlsh;
        Date endDate;
        HashMap<String, String> param = new HashMap<String, String>();
        Date beginDate = new Date();
        if (StringUtils.equals((CharSequence)zzsjfw, (CharSequence)"MONTH")) {
            endDate = DateUtils.addMonths((Date)beginDate, (int)1);
            param.put("beginDate", MONTH_DATE_FORMAT.format(beginDate) + "01");
            param.put("endDate", MONTH_DATE_FORMAT.format(endDate) + "01");
        } else if (StringUtils.equals((CharSequence)zzsjfw, (CharSequence)"YEAR")) {
            endDate = DateUtils.addYears((Date)beginDate, (int)1);
            param.put("beginDate", YEAR_DATE_FORMAT.format(beginDate) + "0101");
            param.put("endDate", YEAR_DATE_FORMAT.format(endDate) + "0101");
        } else if (StringUtils.equals((CharSequence)zzsjfw, (CharSequence)"ALL")) {
            param.put("beginDate", "");
            param.put("endDate", "");
        } else {
            endDate = DateUtils.addDays((Date)beginDate, (int)1);
            param.put("beginDate", DATE_FORMAT.format(beginDate));
            param.put("endDate", DATE_FORMAT.format(endDate));
        }
        if (StringUtils.isNotBlank((CharSequence)ywlx)) {
            param.put("ywlx", ywlx);
        }
        Integer lsh = (maxlsh = this.bdcLshMapper.getMaxLsh(param)) == null ? 1 : maxlsh + 1;
        this.insertLsh(lsh, ywlx);
        return lsh;
    }

    public String queryBh(String ywlx, String zzsjfw) {
        String nyr = "";
        Integer lsh = this.queryLsh(ywlx, zzsjfw);
        if (StringUtils.equals((CharSequence)zzsjfw, (CharSequence)"YEAR")) {
            nyr = CommonUtil.getCurrYearYear();
        } else if (StringUtils.equals((CharSequence)zzsjfw, (CharSequence)"MONTH")) {
            nyr = CommonUtil.getCurrYearMonth();
        } else if (StringUtils.equals((CharSequence)zzsjfw, (CharSequence)"DAY")) {
            nyr = CommonUtil.getCurrDay();
        }
        return nyr + String.format("%04d", lsh);
    }

    private void insertLsh(Integer lsh, String ywlx) {
        HashMap<String, Object> lshVo = new HashMap<String, Object>();
        lshVo.put("lshid", UUIDGenerator.generate());
        lshVo.put("lsh", lsh);
        lshVo.put("ywlx", ywlx);
        this.bdcLshMapper.insertLsh(lshVo);
    }
}

