/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.core.service.impl;

import cn.gtmap.realestate.accept.core.mapper.BdcSlYwxxMapper;
import cn.gtmap.realestate.accept.core.service.BdcSlSjclService;
import cn.gtmap.realestate.accept.core.service.BdcSlXmLsgxService;
import cn.gtmap.realestate.accept.core.service.BdcSlXmService;
import cn.gtmap.realestate.accept.service.BdcSlService;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlXmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlXmLsgxDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlXmDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlYwxxDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlxxDTO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.core.support.mybatis.page.repository.Repo;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class BdcSlXmServiceImpl
implements BdcSlXmService,
BdcSlService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcSlSjclService bdcSlSjclService;
    @Autowired
    private BdcSlXmLsgxService bdcSlXmLsgxService;
    @Autowired
    private BdcSlYwxxMapper bdcSlYwxxMapper;
    @Autowired
    private Repo repo;
    @Autowired
    private MessageProvider messageProvider;

    public BdcSlXmDO queryBdcSlXmByXmid(String xmid) {
        if (StringUtils.isEmpty((CharSequence)xmid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        return (BdcSlXmDO)this.entityMapper.selectByPrimaryKey(BdcSlXmDO.class, (Object)xmid);
    }

    public List<BdcSlXmDO> listBdcSlXmByJbxxid(String jbxxid) {
        List<Object> bdcSlXmDOList = new ArrayList<BdcSlXmDO>();
        if (StringUtils.isNotBlank((CharSequence)jbxxid)) {
            Example example = new Example(BdcSlXmDO.class);
            example.createCriteria().andEqualTo("jbxxid", (Object)jbxxid);
            bdcSlXmDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlXmDOList)) {
            bdcSlXmDOList = Collections.emptyList();
        }
        return bdcSlXmDOList;
    }

    public List<BdcSlXmDO> listBdcSlXmByBdcdyh(String jbxxid, String bdcdyh, String djxl) {
        List<Object> bdcSlXmDOList = new ArrayList<BdcSlXmDO>();
        if (StringUtils.isNotBlank((CharSequence)jbxxid) && StringUtils.isNotBlank((CharSequence)bdcdyh) && StringUtils.isNotBlank((CharSequence)djxl)) {
            Example example = new Example(BdcSlXmDO.class);
            example.createCriteria().andEqualTo("jbxxid", (Object)jbxxid).andEqualTo("bdcdyh", (Object)bdcdyh).andEqualTo("djxl", (Object)djxl);
            bdcSlXmDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlXmDOList)) {
            bdcSlXmDOList = Collections.emptyList();
        }
        return bdcSlXmDOList;
    }

    public BdcSlXmDO insertBdcSlXm(BdcSlXmDO bdcSlXmDO) {
        if (bdcSlXmDO != null) {
            if (StringUtils.isBlank((CharSequence)bdcSlXmDO.getXmid())) {
                bdcSlXmDO.setXmid(UUIDGenerator.generate());
            }
            this.entityMapper.insertSelective((Object)bdcSlXmDO);
        }
        return bdcSlXmDO;
    }

    public Integer updateBdcSlXm(BdcSlXmDO bdcSlXmDO) {
        int result = 0;
        if (bdcSlXmDO == null || !StringUtils.isNotBlank((CharSequence)bdcSlXmDO.getXmid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        result = this.entityMapper.updateByPrimaryKeySelective((Object)bdcSlXmDO);
        return result;
    }

    public Integer deleteBdcSlXmByXmid(String xmid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            result = this.entityMapper.deleteByPrimaryKey(BdcSlXmDO.class, (Object)xmid);
        }
        return result;
    }

    public Integer deleteBdcSlXmByJbxxid(String jbxxid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)jbxxid)) {
            Example example = new Example(BdcSlXmDO.class);
            example.createCriteria().andEqualTo("jbxxid", (Object)jbxxid);
            result = this.entityMapper.deleteByExample(example);
        }
        return result;
    }

    public List<BdcSlYwxxDTO> listBdcSLXmDTOByJbxxid(String jbxxid) {
        List<Object> bdcSlYwxxDTOList = new ArrayList<BdcSlYwxxDTO>();
        if (StringUtils.isNotBlank((CharSequence)jbxxid)) {
            HashMap map = Maps.newHashMap();
            map.put("jbxxid", jbxxid);
            bdcSlYwxxDTOList = this.bdcSlYwxxMapper.listBdcSLXmByPageOrder((Map)map);
        }
        if (CollectionUtils.isEmpty(bdcSlYwxxDTOList)) {
            bdcSlYwxxDTOList = Collections.emptyList();
        }
        return bdcSlYwxxDTOList;
    }

    public Page<BdcSlYwxxDTO> listBdcSLXmDTOByPage(Pageable pageable, Map map) {
        return this.repo.selectPaging("listBdcSLXmByPageOrder", (Object)map, pageable);
    }

    public BdcSlxxDTO queryBdcSlxx(String jbxxid, BdcSlxxDTO bdcSlxxDTO) {
        List bdcSlXmDOList = this.listBdcSlXmByJbxxid(jbxxid);
        if (CollectionUtils.isNotEmpty((Collection)bdcSlXmDOList)) {
            ArrayList<BdcSlXmDTO> bdcSlXmDTOList = new ArrayList<BdcSlXmDTO>();
            for (BdcSlXmDO bdcSlXmDO : bdcSlXmDOList) {
                BdcSlXmDTO bdcSlXmDTO = new BdcSlXmDTO();
                bdcSlXmDTO.setBdcSlXm(bdcSlXmDO);
                List bdcSlXmLsgxDOList = this.bdcSlXmLsgxService.listBdcSlXmLsgxByXmid(bdcSlXmDO.getXmid());
                if (CollectionUtils.isNotEmpty((Collection)bdcSlXmLsgxDOList)) {
                    bdcSlXmDTO.setBdcSlXmLsgxList(bdcSlXmLsgxDOList);
                }
                bdcSlXmDTOList.add(bdcSlXmDTO);
            }
            bdcSlxxDTO.setBdcSlXmList(bdcSlXmDTOList);
        }
        return bdcSlxxDTO;
    }

    public void updateBdcSlxx(BdcSlxxDTO bdcSlxxDTO) {
        if (bdcSlxxDTO != null && CollectionUtils.isNotEmpty((Collection)bdcSlxxDTO.getBdcSlXmList())) {
            List bdcSlXmDTOList = bdcSlxxDTO.getBdcSlXmList();
            for (BdcSlXmDTO bdcSlXmDTO : bdcSlXmDTOList) {
                if (bdcSlXmDTO.getBdcSlXm() != null) {
                    this.updateBdcSlXm(bdcSlXmDTO.getBdcSlXm());
                }
                if (!CollectionUtils.isNotEmpty((Collection)bdcSlXmDTO.getBdcSlXmLsgxList())) continue;
                List bdcSlXmLsgxDOList = bdcSlXmDTO.getBdcSlXmLsgxList();
                for (BdcSlXmLsgxDO bdcSlXmLsgxDO : bdcSlXmLsgxDOList) {
                    this.bdcSlXmLsgxService.updateBdcSlXmLsgx(bdcSlXmLsgxDO);
                }
            }
        }
    }

    public void deleteSlxx(String jbxxid) {
        List bdcSlXmDOList = this.listBdcSlXmByJbxxid(jbxxid);
        if (CollectionUtils.isNotEmpty((Collection)bdcSlXmDOList)) {
            this.deleteBdcSlXmByJbxxid(jbxxid);
            for (BdcSlXmDO bdcSlXmDO : bdcSlXmDOList) {
                this.bdcSlSjclService.deleteBdcSlSjclByXmid(bdcSlXmDO.getXmid());
                this.bdcSlXmLsgxService.deleteBdcSlXmLsgxByXmid(bdcSlXmDO.getXmid());
            }
        }
    }
}

