/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.core.service.impl;

import cn.gtmap.realestate.accept.core.service.BdcSlXmLsgxService;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlXmLsgxDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcSlXmLsgxServiceImpl
implements BdcSlXmLsgxService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProvider messageProvider;

    public BdcSlXmLsgxDO queryBdcSlXmLsgxByGxid(String gxid) {
        if (StringUtils.isBlank((CharSequence)gxid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        return (BdcSlXmLsgxDO)this.entityMapper.selectByPrimaryKey(BdcSlXmLsgxDO.class, (Object)gxid);
    }

    public List<BdcSlXmLsgxDO> listBdcSlXmLsgxByXmid(String xmid) {
        List<Object> bdcSlXmLsgxDOList = new ArrayList<BdcSlXmLsgxDO>();
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlXmLsgxDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid);
            bdcSlXmLsgxDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlXmLsgxDOList)) {
            bdcSlXmLsgxDOList = Collections.emptyList();
        }
        return bdcSlXmLsgxDOList;
    }

    public BdcSlXmLsgxDO insertBdcSlXmLsgx(BdcSlXmLsgxDO bdcSlXmLsgxDO) {
        if (bdcSlXmLsgxDO != null) {
            if (StringUtils.isBlank((CharSequence)bdcSlXmLsgxDO.getGxid())) {
                bdcSlXmLsgxDO.setGxid(UUIDGenerator.generate());
            }
            this.entityMapper.insertSelective((Object)bdcSlXmLsgxDO);
        }
        return bdcSlXmLsgxDO;
    }

    public Integer updateBdcSlXmLsgx(BdcSlXmLsgxDO bdcSlXmLsgxDO) {
        if (bdcSlXmLsgxDO == null || !StringUtils.isNotBlank((CharSequence)bdcSlXmLsgxDO.getGxid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        int result = this.entityMapper.updateByPrimaryKeySelective((Object)bdcSlXmLsgxDO);
        return result;
    }

    public Integer deleteBdcSlXmLsgxByGxid(String gxid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)gxid)) {
            result = this.entityMapper.deleteByPrimaryKey(BdcSlXmLsgxDO.class, (Object)gxid);
        }
        return result;
    }

    public Integer deleteBdcSlXmLsgxByXmid(String xmid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlXmLsgxDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid);
            result = this.entityMapper.deleteByExample(example);
        }
        return result;
    }
}

