/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.core.service.impl;

import cn.gtmap.realestate.accept.core.service.BdcSlSqrService;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSqrDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcSlSqrServiceImpl
implements BdcSlSqrService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProvider messageProvider;

    public BdcSlSqrDO queryBdcSlSqrBySqrid(String sqrid) {
        if (StringUtils.isEmpty((CharSequence)sqrid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        return (BdcSlSqrDO)this.entityMapper.selectByPrimaryKey(BdcSlSqrDO.class, (Object)sqrid);
    }

    public List<BdcSlSqrDO> listBdcSlSqrByXmid(String xmid) {
        List<Object> bdcSlSqrDOList = new ArrayList<BdcSlSqrDO>();
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlSqrDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid);
            bdcSlSqrDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlSqrDOList)) {
            bdcSlSqrDOList = Collections.emptyList();
        }
        return bdcSlSqrDOList;
    }

    public BdcSlSqrDO insertBdcSlSqr(BdcSlSqrDO bdcSlSqrDO) {
        if (bdcSlSqrDO != null) {
            if (StringUtils.isBlank((CharSequence)bdcSlSqrDO.getSqrid())) {
                bdcSlSqrDO.setSqrid(UUIDGenerator.generate());
            }
            this.entityMapper.insertSelective((Object)bdcSlSqrDO);
        }
        return bdcSlSqrDO;
    }

    public Integer updateBdcSlSqr(BdcSlSqrDO bdcSlSqrDO) {
        if (bdcSlSqrDO == null || !StringUtils.isNotBlank((CharSequence)bdcSlSqrDO.getSqrid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        int result = this.entityMapper.updateByPrimaryKeySelective((Object)bdcSlSqrDO);
        return result;
    }

    public Integer deleteBdcSlSqrBySqrid(String sqrid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)sqrid)) {
            result = this.entityMapper.deleteByPrimaryKey(BdcSlSqrDO.class, (Object)sqrid);
        }
        return result;
    }

    public Integer deleteBdcSlSqrByXmid(String xmid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlSqrDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid);
            result = this.entityMapper.deleteByExample(example);
        }
        return result;
    }
}

