/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.core.service.impl;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.realestate.accept.core.service.BdcSlSjclPzService;
import cn.gtmap.realestate.accept.core.service.BdcSlSjclService;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSjclDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcSlSjclServiceImpl
implements BdcSlSjclService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProvider messageProvider;
    @Autowired
    protected UserManagerUtils userManagerUtils;
    @Autowired
    private BdcSlSjclPzService bdcSlSjclPzService;
    @Autowired
    private StorageClient storageClient;

    public BdcSlSjclDO queryBdcSlSjclBySjclid(String sjclid) {
        if (StringUtils.isEmpty((CharSequence)sjclid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        return (BdcSlSjclDO)this.entityMapper.selectByPrimaryKey(BdcSlSjclDO.class, (Object)sjclid);
    }

    public BdcSlSjclDO queryBdcSlSjclByWjzxid(String wjzxid) {
        if (StringUtils.isNotBlank((CharSequence)wjzxid)) {
            Example example = new Example(BdcSlSjclDO.class);
            example.createCriteria().andEqualTo("wjzxid", (Object)wjzxid);
            List bdcSlSjclDOList = this.entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)bdcSlSjclDOList)) {
                return (BdcSlSjclDO)bdcSlSjclDOList.get(0);
            }
        }
        return null;
    }

    public List<BdcSlSjclDO> listBdcSlSjclByXmid(String xmid) {
        List<Object> bdcSlSjclDOList = new ArrayList<BdcSlSjclDO>();
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlSjclDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid);
            example.setOrderByClause("xh");
            bdcSlSjclDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlSjclDOList)) {
            bdcSlSjclDOList = Collections.emptyList();
        }
        return bdcSlSjclDOList;
    }

    public List<BdcSlSjclDO> listBdcSlSjclByGzlslid(String gzlslid) {
        List<Object> bdcSlSjclDOList = new ArrayList<BdcSlSjclDO>();
        if (StringUtils.isNotBlank((CharSequence)gzlslid)) {
            Example example = new Example(BdcSlSjclDO.class);
            example.createCriteria().andEqualTo("gzlslid", (Object)gzlslid);
            example.setOrderByClause("xh");
            bdcSlSjclDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlSjclDOList)) {
            bdcSlSjclDOList = Collections.emptyList();
        }
        return bdcSlSjclDOList;
    }

    public BdcSlSjclDO bdcSlSjclByXmidAndWjzxid(String xmid, String wjzxid) {
        if (StringUtils.isNotBlank((CharSequence)xmid) && StringUtils.isNotBlank((CharSequence)wjzxid)) {
            Example example = new Example(BdcSlSjclDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid).andEqualTo("wjzxid", (Object)wjzxid);
            List bdcSlSjclDOList = this.entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)bdcSlSjclDOList)) {
                return (BdcSlSjclDO)bdcSlSjclDOList.get(0);
            }
        }
        return null;
    }

    public List<BdcSlSjclDO> listBdcSlSjcl(String xmid, String gzlslid, String clmc) {
        List<Object> bdcSlSjclDOList = new ArrayList<BdcSlSjclDO>();
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlSjclDO.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank((CharSequence)xmid)) {
                criteria.andEqualTo("xmid", (Object)xmid);
            }
            if (StringUtils.isNotBlank((CharSequence)gzlslid)) {
                criteria.andEqualTo("gzlslid", (Object)gzlslid);
            }
            if (StringUtils.isNotBlank((CharSequence)clmc)) {
                criteria.andEqualTo("clmc", (Object)clmc);
            }
            example.setOrderByClause("xh");
            bdcSlSjclDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlSjclDOList)) {
            bdcSlSjclDOList = Collections.emptyList();
        }
        return bdcSlSjclDOList;
    }

    public BdcSlSjclDO insertBdcSlSjcl(BdcSlSjclDO bdcSlSjclDO) {
        if (bdcSlSjclDO != null) {
            if (StringUtils.isBlank((CharSequence)bdcSlSjclDO.getSjclid())) {
                bdcSlSjclDO.setSjclid(UUIDGenerator.generate());
            }
            this.entityMapper.insertSelective((Object)bdcSlSjclDO);
        }
        return bdcSlSjclDO;
    }

    public Integer updateBdcSlSjcl(BdcSlSjclDO bdcSlSjclDO) {
        if (bdcSlSjclDO == null || !StringUtils.isNotBlank((CharSequence)bdcSlSjclDO.getSjclid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        int result = this.entityMapper.updateByPrimaryKeySelective((Object)bdcSlSjclDO);
        return result;
    }

    public Integer deleteBdcSlSjclBySjclid(String sjclid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)sjclid)) {
            result = this.entityMapper.deleteByPrimaryKey(BdcSlSjclDO.class, (Object)sjclid);
        }
        return result;
    }

    public Integer deleteBdcSlSjclByXmid(String xmid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            Example example = new Example(BdcSlSjclDO.class);
            example.createCriteria().andEqualTo("xmid", (Object)xmid);
            result = this.entityMapper.deleteByExample(example);
        }
        return result;
    }
}

