/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.core.service.impl;

import cn.gtmap.realestate.accept.core.service.BdcSlSfxxService;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSfxxDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcSlSfxxServiceImpl
implements BdcSlSfxxService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProvider messageProvider;

    public BdcSlSfxxDO queryBdcSlSfxxBySfxxid(String sfxxid) {
        if (StringUtils.isEmpty((CharSequence)sfxxid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        return (BdcSlSfxxDO)this.entityMapper.selectByPrimaryKey(BdcSlSfxxDO.class, (Object)sfxxid);
    }

    public List<BdcSlSfxxDO> listBdcSlSfxxByJbxxid(String jbxxid) {
        List<Object> bdcSlSfxxDOList = new ArrayList<BdcSlSfxxDO>();
        if (StringUtils.isNotBlank((CharSequence)jbxxid)) {
            Example example = new Example(BdcSlSfxxDO.class);
            example.createCriteria().andEqualTo("jbxxid", (Object)jbxxid);
            bdcSlSfxxDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlSfxxDOList)) {
            bdcSlSfxxDOList = Collections.emptyList();
        }
        return bdcSlSfxxDOList;
    }

    public BdcSlSfxxDO insertBdcSlSfxx(BdcSlSfxxDO bdcSlSfxxDO) {
        if (bdcSlSfxxDO != null) {
            if (StringUtils.isBlank((CharSequence)bdcSlSfxxDO.getSfxxid())) {
                bdcSlSfxxDO.setSfxxid(UUIDGenerator.generate());
            }
            this.entityMapper.insertSelective((Object)bdcSlSfxxDO);
        }
        return bdcSlSfxxDO;
    }

    public Integer updateBdcSlSfxx(BdcSlSfxxDO bdcSlSfxxDO) {
        if (bdcSlSfxxDO == null || !StringUtils.isNotBlank((CharSequence)bdcSlSfxxDO.getSfxxid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        int result = this.entityMapper.updateByPrimaryKeySelective((Object)bdcSlSfxxDO);
        return result;
    }

    public Integer deleteBdcSlSfxxBySfxxid(String sfxxid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)sfxxid)) {
            result = this.entityMapper.deleteByPrimaryKey(BdcSlSfxxDO.class, (Object)sfxxid);
        }
        return result;
    }

    public Integer deleteBdcSlSfxxByJbxxid(String jbxxid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)jbxxid)) {
            Example example = new Example(BdcSlSfxxDO.class);
            example.createCriteria().andEqualTo("jbxxid", (Object)jbxxid);
            result = this.entityMapper.deleteByExample(example);
        }
        return result;
    }
}

