/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.core.service.impl;

import cn.gtmap.realestate.accept.core.service.BdcSlSfxmService;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSfxmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSfxmPzDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcSlSfxmServiceImpl
implements BdcSlSfxmService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProvider messageProvider;

    public BdcSlSfxmDO queryBdcSlSfxmBySfxmid(String sfxmid) {
        if (StringUtils.isEmpty((CharSequence)sfxmid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        return (BdcSlSfxmDO)this.entityMapper.selectByPrimaryKey(BdcSlSfxmDO.class, (Object)sfxmid);
    }

    public List<BdcSlSfxmDO> listBdcSlSfxmBySfxxid(String sfxxid) {
        List<Object> bdcSlSfxmDOList = new ArrayList<BdcSlSfxmDO>();
        if (StringUtils.isNotBlank((CharSequence)sfxxid)) {
            Example example = new Example(BdcSlSfxmDO.class);
            example.createCriteria().andEqualTo("sfxxid", (Object)sfxxid);
            example.setOrderByClause("xh");
            bdcSlSfxmDOList = this.entityMapper.selectByExample(example);
        }
        if (CollectionUtils.isEmpty(bdcSlSfxmDOList)) {
            bdcSlSfxmDOList = Collections.emptyList();
        }
        return bdcSlSfxmDOList;
    }

    public List<BdcSlSfxmDO> cshBdcSlSfxm(String gzlslid, List<BdcSlSfxmPzDO> bdcSlSfxmPzDOList) {
        ArrayList<BdcSlSfxmDO> bdcSlSfxmDOList = new ArrayList<BdcSlSfxmDO>();
        if (CollectionUtils.isNotEmpty(bdcSlSfxmPzDOList)) {
            for (BdcSlSfxmPzDO bdcSlSfxmPzDO : bdcSlSfxmPzDOList) {
                BdcSlSfxmDO bdcSlSfxmDO = new BdcSlSfxmDO();
                BeanUtils.copyProperties((Object)bdcSlSfxmPzDO, (Object)bdcSlSfxmDO);
                bdcSlSfxmDO.setSfxxid(gzlslid);
                bdcSlSfxmDO = this.insertBdcSlSfxm(bdcSlSfxmDO);
                bdcSlSfxmDOList.add(bdcSlSfxmDO);
            }
        }
        return bdcSlSfxmDOList;
    }

    public BdcSlSfxmDO insertBdcSlSfxm(BdcSlSfxmDO bdcSlSfxmDO) {
        if (bdcSlSfxmDO != null) {
            if (StringUtils.isBlank((CharSequence)bdcSlSfxmDO.getSfxmid())) {
                bdcSlSfxmDO.setSfxmid(UUIDGenerator.generate());
            }
            this.entityMapper.insertSelective((Object)bdcSlSfxmDO);
        }
        return bdcSlSfxmDO;
    }

    public Integer updateBdcSlSfxm(BdcSlSfxmDO bdcSlSfxmDO) {
        if (bdcSlSfxmDO == null || !StringUtils.isNotBlank((CharSequence)bdcSlSfxmDO.getSfxmid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("message.noparameter"));
        }
        int result = this.entityMapper.updateByPrimaryKeySelective((Object)bdcSlSfxmDO);
        return result;
    }

    public Integer deleteBdcSlSfxmBySfxmid(String sfxmid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)sfxmid)) {
            result = this.entityMapper.deleteByPrimaryKey(BdcSlSfxmDO.class, (Object)sfxmid);
        }
        return result;
    }

    public Integer deleteBdcSlSfxmBySfxxid(String sfxxid) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)sfxxid)) {
            Example example = new Example(BdcSlSfxmDO.class);
            example.createCriteria().andEqualTo("sfxxid", (Object)sfxxid);
            result = this.entityMapper.deleteByExample(example);
        }
        return result;
    }
}

