/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.web;

import cn.gtmap.realestate.core.entity.PfRoleVo;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.service.PfRoleService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/role"})
public class PfRoleController {
    @Autowired
    private PfRoleService pfRoleService;

    @RequestMapping(value={"/toPfRoleList"}, method={RequestMethod.GET})
    public String toPfUserList(Model model) {
        return this.pfRoleService.toPfRoleList(model);
    }

    @RequestMapping(value={"/toPfRoleForm"}, method={RequestMethod.GET})
    public String toPfRoleForm(Model model, String roleId, String type) {
        return this.pfRoleService.toPfRoleForm(model, roleId, type);
    }

    @ResponseBody
    @RequestMapping(value={"/getPfRoleList"}, method={RequestMethod.POST})
    public ResCommonResult getPfRoleList() {
        return this.pfRoleService.getPfRoleList();
    }

    @ResponseBody
    @RequestMapping(value={"/getPfRoleMenuJson"}, method={RequestMethod.POST})
    public List<Map> getPfRoleMenuJson(PfRoleVo pfRoleVo) {
        return this.pfRoleService.getPfRoleMenuJson(pfRoleVo.getRoleId());
    }

    @ResponseBody
    @RequestMapping(value={"/insertMenuOfRole"}, method={RequestMethod.POST})
    public ResCommonResult insertMenuOfRole(PfRoleVo pfRoleVo) {
        return this.pfRoleService.insertMenuOfRole(pfRoleVo);
    }

    @ResponseBody
    @RequestMapping(value={"/deleteMenuOfRole"}, method={RequestMethod.POST})
    public ResCommonResult deleteMenuOfRole(PfRoleVo pfRoleVo) {
        return this.pfRoleService.deleteMenuOfRole(pfRoleVo);
    }

    @ResponseBody
    @RequestMapping(value={"/insertPfRole"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult insertPfRole(PfRoleVo pfRoleVo) {
        return this.pfRoleService.insertPfRole(pfRoleVo);
    }

    @ResponseBody
    @RequestMapping(value={"/updatePfRole"}, method={RequestMethod.POST})
    public ResCommonResult updatePfRole(PfRoleVo pfRoleVo) {
        return this.pfRoleService.updatePfRole(pfRoleVo);
    }

    @ResponseBody
    @RequestMapping(value={"/deletePfRole"}, method={RequestMethod.POST})
    public ResCommonResult deletePfRole(PfRoleVo pfRoleVo) {
        return this.pfRoleService.deletePfRole(pfRoleVo);
    }
}

