/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.web;

import cn.gtmap.realestate.core.entity.PfBusinessDo;
import cn.gtmap.realestate.core.entity.PfBusinessResourceVo;
import cn.gtmap.realestate.core.entity.PfPartitionInfoDo;
import cn.gtmap.realestate.core.entity.PfResourceGroupDo;
import cn.gtmap.realestate.core.entity.PfResourcePartitionDo;
import cn.gtmap.realestate.core.service.PfBusinessService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/business"})
public class PfBusinessController {
    @Autowired
    private PfBusinessService pfBusinessService;

    @RequestMapping(value={"/toPfBusinessList"}, method={RequestMethod.GET})
    public String toPfBusinessList() {
        return this.pfBusinessService.toPfBusinessList();
    }

    @RequestMapping(value={"/toPfBusinessForm"}, method={RequestMethod.GET})
    public String toPfBusinessForm(String id, Model model) {
        return this.pfBusinessService.toPfBusinessForm(id, model);
    }

    @RequestMapping(value={"/toPfResourceGroupForm"}, method={RequestMethod.GET})
    public String toPfResourceGroupForm(String businessId, String id, Model model) {
        return this.pfBusinessService.toPfResourceGroupForm(businessId, id, model);
    }

    @RequestMapping(value={"/toPfResourceForm"}, method={RequestMethod.GET})
    public String toPfResourceForm(String businessId, String groupId, String id, Model model) {
        return this.pfBusinessService.toPfResourceForm(businessId, groupId, id, model);
    }

    @RequestMapping(value={"/toPfPartitionForm"}, method={RequestMethod.GET})
    public String toPfPartitionForm(String resourceId, Model model) {
        return this.pfBusinessService.toPfPartitionForm(resourceId, model);
    }

    @RequestMapping(value={"/toPfResourcePartitionForm"}, method={RequestMethod.GET})
    public String toPfResourcePartitionForm(String type, String partitionId, String resourceId, Model model) {
        return this.pfBusinessService.toPfResourcePartitionForm(type, partitionId, resourceId, model);
    }

    @RequestMapping(value={"/toPfPartitionInfoForm"}, method={RequestMethod.GET})
    public String toPfPartitionInfoForm(String type, String pfPartitionInfoId, String partitionId, Model model) {
        return this.pfBusinessService.toPfPartitionInfoForm(type, pfPartitionInfoId, partitionId, model);
    }

    @ResponseBody
    @RequestMapping(value={"/getPfBusinessList"}, method={RequestMethod.POST})
    public Object getPfBusinessList(PfBusinessDo pfBusinessDo) {
        return this.pfBusinessService.getPfBusinessList(pfBusinessDo);
    }

    @ResponseBody
    @RequestMapping(value={"/getPfResourcePartitionList"}, method={RequestMethod.POST})
    public Object getPfResourcePartitionList(PfResourcePartitionDo pfResourcePartitionDo) {
        return this.pfBusinessService.getPfResourcePartitionList(pfResourcePartitionDo);
    }

    @ResponseBody
    @RequestMapping(value={"/getPfPartitionInfoList"}, method={RequestMethod.POST})
    public Object getPfPartitionInfoList(PfPartitionInfoDo pfPartitionInfoDo) {
        return this.pfBusinessService.getPfPartitionInfoList(pfPartitionInfoDo);
    }

    @ResponseBody
    @RequestMapping(value={"/orgBusinessResouce"}, method={RequestMethod.POST})
    public String orgBusinessResouce() {
        return this.pfBusinessService.orgBusinessResouce();
    }

    @ResponseBody
    @RequestMapping(value={"/getGroupByBusinessId"}, method={RequestMethod.POST})
    public List<PfResourceGroupDo> getGroupByBusinessId(String businessId) {
        return this.pfBusinessService.getGroupByBusinessId(businessId);
    }

    @ResponseBody
    @RequestMapping(value={"/modify"}, method={RequestMethod.POST})
    public Object modify(PfBusinessResourceVo pfBusinessResourceVo) {
        return this.pfBusinessService.update(pfBusinessResourceVo);
    }

    @ResponseBody
    @RequestMapping(value={"/insert"}, method={RequestMethod.POST})
    public Object insert(PfBusinessResourceVo pfBusinessResourceVo) {
        return this.pfBusinessService.insert(pfBusinessResourceVo);
    }

    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public Object del(PfBusinessResourceVo pfBusinessResourceVo) {
        return this.pfBusinessService.delete(pfBusinessResourceVo);
    }

    @ResponseBody
    @RequestMapping(value={"/insertPfResourcePartition"}, method={RequestMethod.POST})
    public Object insertPfResourcePartition(PfResourcePartitionDo pfResourcePartitionDo) {
        return this.pfBusinessService.insertPfResourcePartition(pfResourcePartitionDo);
    }

    @ResponseBody
    @RequestMapping(value={"/updatePfResourcePartition"}, method={RequestMethod.POST})
    public Object updatePfResourcePartition(PfResourcePartitionDo pfResourcePartitionDo) {
        return this.pfBusinessService.updatePfResourcePartition(pfResourcePartitionDo);
    }

    @ResponseBody
    @RequestMapping(value={"/deletePfResourcePartition"}, method={RequestMethod.POST})
    public Object deletePfResourcePartition(PfResourcePartitionDo pfResourcePartitionDo) {
        return this.pfBusinessService.deletePfResourcePartition(pfResourcePartitionDo);
    }

    @ResponseBody
    @RequestMapping(value={"/insertPfPartitionInfo"}, method={RequestMethod.POST})
    public Object insertPfPartitionInfo(PfPartitionInfoDo pfPartitionInfoDo) {
        return this.pfBusinessService.insertPfPartitionInfo(pfPartitionInfoDo);
    }

    @ResponseBody
    @RequestMapping(value={"/updatePfPartitionInfo"}, method={RequestMethod.POST})
    public Object updatePfPartitionInfo(PfPartitionInfoDo pfPartitionInfoDo) {
        return this.pfBusinessService.updatePfPartitionInfo(pfPartitionInfoDo);
    }

    @ResponseBody
    @RequestMapping(value={"/deletePfPartitionInfo"}, method={RequestMethod.POST})
    public Object deletePfPartitionInfo(PfPartitionInfoDo pfPartitionInfoDo) {
        return this.pfBusinessService.deletePfPartitionInfo(pfPartitionInfoDo);
    }
}

