/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.entity.PfRoleDo;
import cn.gtmap.realestate.core.entity.PfUserDo;
import cn.gtmap.realestate.core.mapper.PfOrganMapper;
import cn.gtmap.realestate.core.mapper.PfRoleMapper;
import cn.gtmap.realestate.core.mapper.PfUserMapper;
import cn.gtmap.realestate.core.model.AuthorityInfo;
import cn.gtmap.realestate.core.model.UserInfo;
import cn.gtmap.realestate.core.service.PfOrganService;
import cn.gtmap.realestate.util.ConfigConstants;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Autowired
    private PfUserMapper pfUserMapper;
    @Autowired
    private PfOrganMapper pfOrganMapper;
    @Autowired
    private PfRoleMapper pfRoleMapper;
    @Autowired
    private PfOrganService pfOrganService;

    public UserDetails loadUserByUsername(String uname) throws UsernameNotFoundException {
        if (StringUtils.isBlank((CharSequence)uname)) {
            throw new UsernameNotFoundException("\u7528\u6237\u540d\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        UserInfo user = new UserInfo();
        PfUserDo userVo = this.pfUserMapper.getPfUserByloginName(uname);
        if (null == userVo) {
            throw new UsernameNotFoundException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        user.setId(userVo.getUserId());
        user.setUsername(userVo.getUserName());
        user.setPassword(userVo.getLoginPassword());
        user.setLstOragn(this.pfOrganMapper.getPfOrganListByUserId(userVo.getUserId()));
        HashSet<Object> authorities = new HashSet<Object>(2);
        if (ConfigConstants.STRING_ZERO.equals(userVo.getUserId())) {
            user.setAdmin(true);
            authorities.add(UserInfo.ADMIN);
        } else {
            List roleDos = this.pfRoleMapper.getRoleListByUserId(userVo.getUserId());
            user.setListRole(roleDos);
            authorities.add(UserInfo.USER);
            StringBuilder roleIdBuilder = new StringBuilder();
            for (PfRoleDo pfRoleDo : roleDos) {
                authorities.add(new AuthorityInfo(pfRoleDo.getRoleName()));
                roleIdBuilder.append(pfRoleDo.getRoleId()).append(",");
                if (!pfRoleDo.getRoleName().endsWith("\u7cfb\u7edf\u7ba1\u7406\u5458")) continue;
                user.setAdmin(true);
                authorities.add(UserInfo.ADMIN);
            }
            String roleIds = roleIdBuilder.toString();
            if (StringUtils.isNotBlank((CharSequence)roleIds)) {
                roleIds = roleIds.substring(0, roleIds.length() - 1);
            }
            user.setRoleIds(roleIds);
        }
        if (!user.isAdmin()) {
            throw new RuntimeException("\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u9650\u5236\u8bbf\u95ee\uff01");
        }
        user.setAuthorities(authorities);
        user.setRegionCode(this.pfOrganService.getRegionCodeByUserId(userVo.getUserId()));
        return user;
    }
}

