/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.mapper.PfWorkflowForImageMapper;
import cn.gtmap.realestate.core.service.PfWorkflowForImageService;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class PfWorkflowForImageServiceImpl
implements PfWorkflowForImageService {
    @Autowired
    PfWorkflowForImageMapper pfWorkflowForImageMapper;

    public String toWorkflowForImage(String wdid, Model model) {
        model.addAttribute("wdid", (Object)wdid);
        return "workflowForImage/image";
    }

    public Map getWorkflowForImage(String wdid) {
        HashMap<String, String> parameMap = new HashMap<String, String>();
        parameMap.put("wdid", wdid);
        Map resMap = this.pfWorkflowForImageMapper.getWorkflowXmlByWdid(parameMap);
        Clob workflowLocationClob = (Clob)MapUtils.getObject((Map)resMap, (Object)"WORKFLOW_LOCATION");
        Clob workflowXmlClob = (Clob)MapUtils.getObject((Map)resMap, (Object)"WORKFLOW_XML");
        ArrayList activityListRet = new ArrayList();
        int marginLeft = 0;
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        try {
            SAXReader readerSy = new SAXReader();
            Document domSy = readerSy.read((Reader)new StringReader(this.clobToString(workflowLocationClob)));
            List locationList = this.getAllLocationList(domSy);
            SAXReader reader = new SAXReader();
            Document dom = reader.read((Reader)new StringReader(this.clobToString(workflowXmlClob)));
            List transitionList = this.getTransitionList(dom);
            List activityList = this.getActivityList(dom);
            String beginActivity = this.getBeginActivityDefine(dom);
            String endActivity = this.getEndActivityDefine(dom);
            ArrayList<Map> activityListNew = new ArrayList<Map>();
            if (CollectionUtils.isNotEmpty((Collection)activityList)) {
                for (Map activity : activityList) {
                    for (Map locationMap : locationList) {
                        if (!activity.get("id").equals(locationMap.get("id"))) continue;
                        activity.putAll(locationMap);
                        break;
                    }
                    if (activity.get("id").equals(beginActivity)) {
                        activity.put("jdwz", "1");
                    } else if (activity.get("id").equals(endActivity)) {
                        activity.put("jdwz", "3");
                    } else {
                        activity.put("jdwz", "2");
                    }
                    ArrayList transitionToList = new ArrayList();
                    for (Map transition : transitionList) {
                        if (activity.get("id").equals(beginActivity)) {
                            activity.put("from", beginActivity);
                        } else if (activity.get("id").equals(transition.get("to"))) {
                            activity.put("from", transition.get("from"));
                        }
                        if (!activity.get("id").equals(transition.get("from"))) continue;
                        HashMap transitionMap = new HashMap();
                        transitionMap.put("transitionId", transition.get("id"));
                        transitionMap.put("to", transition.get("to"));
                        transitionToList.add(transitionMap);
                    }
                    activity.put("to", transitionToList);
                    activityListNew.add(activity);
                }
            }
            activityListRet.addAll(activityListNew);
            int maxleft = 0;
            int maxTop = 0;
            for (Map itemMap : locationList) {
                if (Integer.parseInt(MapUtils.getString((Map)itemMap, (Object)"left")) > maxleft) {
                    maxleft = Integer.parseInt(MapUtils.getString((Map)itemMap, (Object)"left"));
                }
                if (Integer.parseInt(MapUtils.getString((Map)itemMap, (Object)"top")) <= maxTop) continue;
                maxTop = Integer.parseInt(MapUtils.getString((Map)itemMap, (Object)"top"));
            }
            if (maxleft > 0) {
                marginLeft = maxleft / 10;
            }
            returnMap.put("maxleft", Integer.valueOf(maxleft));
            returnMap.put("maxTop", Integer.valueOf(maxTop));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        returnMap.put("jdList", activityListRet);
        returnMap.put("marginLeft", Integer.valueOf(marginLeft));
        return returnMap;
    }

    public List<Map<String, String>> getAllLocationList(Document doc) {
        Vector<Map<String, String>> transitionsList = new Vector<Map<String, String>>();
        List lstNodes = doc.selectNodes("//DataSet/Data");
        for (Node tmpNode : lstNodes) {
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("id", tmpNode.valueOf("@id"));
            resMap.put("left", tmpNode.valueOf("@left"));
            resMap.put("top", tmpNode.valueOf("@top"));
            resMap.put("width", tmpNode.valueOf("@width"));
            resMap.put("height", tmpNode.valueOf("@height"));
            transitionsList.add(resMap);
        }
        return transitionsList;
    }

    public List<Map<String, String>> getTransitionList(Document doc) {
        Vector<Map<String, String>> transitionsList = new Vector<Map<String, String>>();
        List lstNodes = doc.selectNodes("//Transitions/Transition");
        for (Node tmpNode : lstNodes) {
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("id", tmpNode.valueOf("@Id"));
            resMap.put("from", tmpNode.valueOf("@From"));
            resMap.put("to", tmpNode.valueOf("@To"));
            transitionsList.add(resMap);
        }
        return transitionsList;
    }

    public List<Map<String, Object>> getActivityList(Document doc) {
        List activityNodeList;
        ArrayList<Map<String, Object>> activityList = new ArrayList<Map<String, Object>>();
        if (doc != null && (activityNodeList = doc.selectNodes("//Activities/Activity")) != null && !activityNodeList.isEmpty()) {
            for (Node actNode : activityNodeList) {
                HashMap<String, String> resMap = new HashMap<String, String>();
                resMap.put("id", actNode.valueOf("@Id"));
                resMap.put("name", actNode.valueOf("@Name"));
                activityList.add(resMap);
            }
        }
        return activityList;
    }

    public String getBeginActivityDefine(Document doc) {
        Node tmpNode;
        if (doc != null && (tmpNode = doc.selectSingleNode("//WorkflowProcess/ExtendedAttributes/ExtendedAttribute[@Name='PROCESS_BEGIN_ACTIVITYID']")) != null) {
            return tmpNode.valueOf("@Value");
        }
        return null;
    }

    public String getEndActivityDefine(Document doc) {
        Node tmpNode;
        if (doc != null && (tmpNode = doc.selectSingleNode("//WorkflowProcess/ExtendedAttributes/ExtendedAttribute[@Name='PROCESS_END_ACTIVITYID']")) != null) {
            return tmpNode.valueOf("@Value");
        }
        return null;
    }

    private String clobToString(Clob clob) throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        try (StringReader reader = new StringReader(clob.getSubString(1L, (int)clob.length()));){
            int bytesRead;
            while ((bytesRead = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, bytesRead);
            }
        }
        return sb.toString();
    }
}

