/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.entity.PfAuthorizeDo;
import cn.gtmap.realestate.core.entity.PfOrganDo;
import cn.gtmap.realestate.core.entity.PfResourceDo;
import cn.gtmap.realestate.core.entity.PfResourcePartitionDo;
import cn.gtmap.realestate.core.entity.PfRoleDo;
import cn.gtmap.realestate.core.entity.PfUserDo;
import cn.gtmap.realestate.core.entity.PfWorkflowDefinitionDo;
import cn.gtmap.realestate.core.mapper.PfAuthorizeMapper;
import cn.gtmap.realestate.core.mapper.PfBusinessMapper;
import cn.gtmap.realestate.core.mapper.PfOrganMapper;
import cn.gtmap.realestate.core.mapper.PfPartitionMapper;
import cn.gtmap.realestate.core.mapper.PfResourceMapper;
import cn.gtmap.realestate.core.mapper.PfRoleMapper;
import cn.gtmap.realestate.core.mapper.PfUserMapper;
import cn.gtmap.realestate.core.mapper.PfWorkflowDefinitionMapper;
import cn.gtmap.realestate.core.model.LayuiPageResultMap;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.service.PfWorkflowDefinitionService;
import cn.gtmap.realestate.core.service.PfWorkflowForImageService;
import cn.gtmap.realestate.util.DateUtil;
import cn.gtmap.realestate.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PfWorkflowDefinitionServiceImpl
implements PfWorkflowDefinitionService {
    @Autowired
    private PfWorkflowDefinitionMapper pfWorkflowDefinitionMapper;
    @Autowired
    private PfBusinessMapper pfBusinessMapper;
    @Autowired
    private PfOrganMapper pfOrganMapper;
    @Autowired
    private PfRoleMapper pfRoleMapper;
    @Autowired
    private PfUserMapper pfUserMapper;
    @Autowired
    private PfWorkflowForImageService pfWorkflowForImageService;
    @Autowired
    private PfResourceMapper pfResourceMapper;
    @Autowired
    private PfPartitionMapper pfPartitionMapper;
    @Autowired
    private PfAuthorizeMapper pfAuthorizeMapper;

    public String toPfWfDefList(Model model) {
        model.addAttribute("businessList", (Object)this.pfBusinessMapper.getPfBusinessList(null));
        return "wf/pfWfDefList";
    }

    public String toPfWfCopyForm(Model model, String wfDefId) {
        model.addAttribute("wfDefId", (Object)wfDefId);
        return "wf/pfWfCopyForm";
    }

    public String toPfWfConfigForm(Model model, String wfDefId) {
        model.addAttribute("wfDefId", (Object)wfDefId);
        return "wf/pfWfConfigForm";
    }

    public String toPfWfEditForm(Model model, String wfDefId) {
        if (StringUtils.isNotBlank((CharSequence)wfDefId)) {
            PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
            if (null != pfWorkflowDefinitionDo) {
                model.addAttribute("workflowDefinitionDo", (Object)pfWorkflowDefinitionDo);
            }
        } else {
            model.addAttribute("workflowDefinitionDo", (Object)new PfWorkflowDefinitionDo());
        }
        model.addAttribute("businessList", (Object)this.pfBusinessMapper.getPfBusinessList(null));
        return "wf/pfWfEditForm";
    }

    public String toPfWfAddParticipantForm(Model model, String type, String activityId, String wfDefId) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"addOrgan")) {
            List pfOrganDoList = this.pfOrganMapper.getPfOrganList();
            model.addAttribute("participantList", (Object)pfOrganDoList);
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"addRole")) {
            List pfRoleDoList = this.pfRoleMapper.getPfRoleList(null);
            model.addAttribute("participantList", (Object)pfRoleDoList);
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"addUser")) {
            List pfUserDoList = this.pfUserMapper.getPfUserList(null);
            model.addAttribute("participantList", (Object)pfUserDoList);
        }
        model.addAttribute("activityId", (Object)activityId);
        model.addAttribute("wfDefId", (Object)wfDefId);
        model.addAttribute("type", (Object)type);
        return "wf/pfWfAddParticipantForm";
    }

    public String toPfWfResourceAndMenuForm(Model model, String type, String activityId, String wfDefId, String subMenuId, String currId) {
        HashMap<String, String> currNodeMap;
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo;
        model.addAttribute("activityId", (Object)activityId);
        model.addAttribute("wfDefId", (Object)wfDefId);
        model.addAttribute("subMenuId", (Object)(StringUtils.isBlank((CharSequence)subMenuId) ? "" : subMenuId));
        model.addAttribute("currId", (Object)currId);
        Node currNode = null;
        if (StringUtils.isNotBlank((CharSequence)currId) && StringUtils.isNotBlank((CharSequence)wfDefId) && null != (pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId))) {
            try {
                Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
                Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
                if (null != activity) {
                    if (StringUtils.isNotBlank((CharSequence)subMenuId)) {
                        List resourceList = activity.selectNodes("Resources/Resource");
                        currNode = this.getResourceNode(subMenuId, resourceList).selectSingleNode("Resource[@Id='" + currId + "']");
                    } else {
                        currNode = activity.selectSingleNode("Resources/Resource[@Id='" + currId + "']");
                    }
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"subMenu")) {
            if (null != currNode) {
                currNodeMap = new HashMap<String, String>(2);
                currNodeMap.put("subMenuName", currNode.valueOf("@Name"));
                currNodeMap.put("visible", currNode.valueOf("@Visible"));
                model.addAttribute("currNode", currNodeMap);
            }
            return "wf/pfWfSubMenuForm";
        }
        if (null != currNode) {
            currNodeMap = new HashMap(2);
            currNodeMap.put("resourceId", currNode.valueOf("@Id"));
            currNodeMap.put("resourceName", currNode.valueOf("@Name"));
            currNodeMap.put("visible", currNode.valueOf("@Visible"));
            model.addAttribute("currNode", currNodeMap);
        }
        model.addAttribute("resourceList", (Object)this.pfResourceMapper.getPfResourceDoList(null));
        return "wf/pfWfResourceForm";
    }

    public String toPfWfAuthorizeResourceForm(Model model, String activityId, String wfDefId, String resourceId) {
        model.addAttribute("wfDefId", (Object)wfDefId);
        model.addAttribute("activityId", (Object)activityId);
        model.addAttribute("resourceId", (Object)resourceId);
        return "wf/pfWfAuthorizeForm";
    }

    public String toPfWfAuthorizeConfigForm(Model model, String authorizeId, String partitionId, String undertakeWorkflowId, String undertakeActivityId) {
        if (StringUtils.isNotBlank((CharSequence)authorizeId)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(2);
            paramMap.put("authorizeId", authorizeId);
            List authorizeResource = this.pfPartitionMapper.getPfPartitionAuthorizationList(paramMap);
            if (!authorizeResource.isEmpty()) {
                Map resultMap = (Map)authorizeResource.get(0);
                resultMap.put("partitionId", partitionId);
                resultMap.put("undertakeWorkflowId", undertakeWorkflowId);
                resultMap.put("undertakeActivityId", undertakeActivityId);
                model.addAttribute("authorizeResource", (Object)resultMap);
            }
        } else {
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            resultMap.put("partitionName", this.pfPartitionMapper.getPfResourcePartitionById(partitionId).getPartitionName());
            resultMap.put("operateType", null);
            resultMap.put("authorizeId", null);
            resultMap.put("partitionId", partitionId);
            resultMap.put("undertakeWorkflowId", undertakeWorkflowId);
            resultMap.put("undertakeActivityId", undertakeActivityId);
            model.addAttribute("authorizeResource", resultMap);
        }
        return "wf/pfWfAuthorizeConfigForm";
    }

    public Object getWfDefList(int page, int limit, String workflowName, String businessId, String isValid) {
        PageHelper.startPage((int)page, (int)limit);
        HashMap<String, String> param = new HashMap<String, String>(1);
        if (StringUtils.isNotBlank((CharSequence)workflowName)) {
            param.put("workflowName", workflowName);
        }
        if (StringUtils.isNotBlank((CharSequence)businessId)) {
            param.put("businessId", businessId);
        }
        if (StringUtils.isNotBlank((CharSequence)isValid)) {
            param.put("isValid", isValid);
        }
        List workflowDefinitionDoList = this.pfWorkflowDefinitionMapper.getWfDefList(param);
        PageInfo pageInfo = new PageInfo(workflowDefinitionDoList);
        return new LayuiPageResultMap((Object)pageInfo.getList(), pageInfo.getTotal());
    }

    public PfWorkflowDefinitionDo getWfDefById(String workflowDefinitionId) {
        return this.pfWorkflowDefinitionMapper.getWfDefById(workflowDefinitionId);
    }

    public void exportPfWfDef(String workflowDefinitionId, HttpServletResponse response) {
        String workflowXml;
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(workflowDefinitionId);
        if (null != pfWorkflowDefinitionDo && (workflowXml = pfWorkflowDefinitionDo.getWorkflowXml()) != null && !StringUtils.equals((CharSequence)workflowXml, (CharSequence)"")) {
            try {
                Document documentXml = DocumentHelper.parseText((String)workflowXml);
                String wfName = pfWorkflowDefinitionDo.getWorkflowName();
                List activities = documentXml.selectNodes("//WorkflowProcess/Activities/Activity");
                for (Node activity : activities) {
                    List userList;
                    List resources = activity.selectNodes("//Resources/Resource");
                    if (!resources.isEmpty()) {
                        for (Node resource : resources) {
                            resource.getParent().remove(resource);
                        }
                    }
                    if ((userList = activity.selectNodes("//Performer/User")).isEmpty()) continue;
                    for (Node user : userList) {
                        user.getParent().remove(user);
                    }
                }
                Document documentPlus = DocumentHelper.createDocument();
                Element rootPlus = documentPlus.addElement("WorkflowDenifition");
                Element wfXml = rootPlus.addElement("WorkflowDenifitionXml");
                wfXml.add(documentXml.getRootElement());
                documentPlus.setXMLEncoding("UTF-8");
                workflowXml = documentPlus.asXML();
                pfWorkflowDefinitionDo.setWorkflowXml(workflowXml);
                String jsonString = JSONObject.toJSONString((Object)pfWorkflowDefinitionDo);
                byte[] xmlBytes = jsonString.getBytes("UTF-8");
                ServletOutputStream out = response.getOutputStream();
                response.setContentType("application/json");
                wfName = URLEncoder.encode(wfName, "UTF-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + wfName + ".json");
                out.write(xmlBytes, 0, xmlBytes.length);
                out.flush();
            }
            catch (IOException | DocumentException e) {
                e.printStackTrace();
            }
        }
    }

    public ResCommonResult importPfWfDef(MultipartFile file) {
        try {
            byte[] fileBytes = file.getBytes();
            String fileJson = new String(fileBytes, "UTF-8");
            PfWorkflowDefinitionDo pfWorkflowDefinitionDo = (PfWorkflowDefinitionDo)JSON.parseObject((String)fileJson, PfWorkflowDefinitionDo.class);
            if (null == pfWorkflowDefinitionDo) {
                return ResCommonResult.error((String)"\u672a\u80fd\u8bc6\u522b\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49json\uff01");
            }
            String workflowId = pfWorkflowDefinitionDo.getWorkflowDefinitionId();
            if (StringUtils.isNotBlank((CharSequence)workflowId)) {
                PfWorkflowDefinitionDo checkWf = this.pfWorkflowDefinitionMapper.getWfDefById(workflowId);
                if (null != checkWf) {
                    return ResCommonResult.error((String)"\u5df2\u5b58\u5728\u8be5\u5de5\u4f5c\u6d41\uff0c\u65e0\u9700\u91cd\u590d\u5bfc\u5165\uff01");
                }
                this.pfWorkflowDefinitionMapper.insertPfWorkflowDefinition(pfWorkflowDefinitionDo);
                return ResCommonResult.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ResCommonResult copyPfWfDef(String wfDefId, String wfDefName) {
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo;
        if (StringUtils.isNotBlank((CharSequence)wfDefId) && null != (pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId))) {
            pfWorkflowDefinitionDo.setWorkflowName(wfDefName);
            String id = StrUtil.getUUID32();
            pfWorkflowDefinitionDo.setWorkflowDefinitionId(id);
            if (StringUtils.isNotBlank((CharSequence)pfWorkflowDefinitionDo.getWorkflowXml())) {
                try {
                    Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
                    Element pkg = documentXml.getRootElement();
                    pkg.addAttribute("Id", id);
                    pkg.addAttribute("Name", wfDefName);
                    Element workflowProcess = (Element)documentXml.selectSingleNode("//WorkflowProcess");
                    workflowProcess.addAttribute("Id", id);
                    workflowProcess.addAttribute("Name", wfDefName);
                    List activities = documentXml.selectNodes("//WorkflowProcess/Activities/Activity");
                    for (Node activity : activities) {
                        Element act = (Element)activity;
                        act.addAttribute("Id", StrUtil.getUUID32());
                    }
                    documentXml.setXMLEncoding("UTF-8");
                    pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
                    pfWorkflowDefinitionDo.setCreateTime(DateUtil.now());
                    pfWorkflowDefinitionDo.setModifyTime(null);
                    this.pfWorkflowDefinitionMapper.insertPfWorkflowDefinition(pfWorkflowDefinitionDo);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public ResCommonResult deletePfWfDef(String wfDefId) {
        try {
            this.pfWorkflowDefinitionMapper.deletePfWorkflowDefinition(wfDefId);
            return ResCommonResult.success((String)"\u5220\u9664\u5de5\u4f5c\u6d41\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u5220\u9664\u5de5\u4f5c\u6d41\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult getWfConfigTree(String wfDefId) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01");
        }
        try {
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            List activities = documentXml.selectNodes("//WorkflowProcess/Activities/Activity");
            LinkedList<Map> activityMapList = new LinkedList<Map>();
            if (!activities.isEmpty()) {
                for (Node activity : activities) {
                    activityMapList.add(this.getActivityMap(documentXml, activity));
                }
            }
            return ResCommonResult.success(activityMapList);
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49xml\uff01");
        }
    }

    private Map getActivityMap(Document document, Node activity) {
        HashMap<String, Object> activityMap = new HashMap<String, Object>(2);
        activityMap.put("name", activity.valueOf("@Name"));
        String activityId = activity.valueOf("@Id");
        activityMap.put("id", activityId);
        activityMap.put("isParent", true);
        activityMap.put("open", true);
        activityMap.put("type", "activity");
        if (StringUtils.equals((CharSequence)activityId, (CharSequence)this.pfWorkflowForImageService.getBeginActivityDefine(document))) {
            activityMap.put("icon", "./../static/pfWorkflowForImage/img/start.png");
        } else if (StringUtils.equals((CharSequence)activityId, (CharSequence)this.pfWorkflowForImageService.getEndActivityDefine(document))) {
            activityMap.put("icon", "./../static/pfWorkflowForImage/img/end.png");
        } else {
            activityMap.put("icon", "./../static/pfWorkflowForImage/img/activity.png");
        }
        LinkedList childrenMapList = new LinkedList();
        HashMap<String, Object> participantsMap = new HashMap<String, Object>(2);
        participantsMap.put("name", "\u53c2\u4e0e\u8005");
        List participantMapList = this.getParticipantMap(activity);
        participantsMap.put("children", participantMapList);
        participantsMap.put("isParent", !participantMapList.isEmpty());
        participantsMap.put("open", true);
        participantsMap.put("icon", "./../static/pfWorkflowForImage/img/participant.png");
        childrenMapList.add(participantsMap);
        HashMap<String, Object> resourcesMap = new HashMap<String, Object>(2);
        resourcesMap.put("name", "\u8d44\u6e90");
        List resourceMapList = this.getResourceMap(activity);
        resourcesMap.put("children", resourceMapList);
        resourcesMap.put("isParent", null != resourceMapList && !resourceMapList.isEmpty());
        resourcesMap.put("open", true);
        resourcesMap.put("icon", "./../static/pfWorkflowForImage/img/resource.png");
        childrenMapList.add(resourcesMap);
        activityMap.put("children", childrenMapList);
        return activityMap;
    }

    private List<Map> getParticipantMap(Node activity) {
        List userList = activity.selectNodes("Performer/User");
        LinkedList<Map> participantMapList = new LinkedList<Map>();
        if (!userList.isEmpty()) {
            for (Node user : userList) {
                PfUserDo pfUserDo;
                String organId = user.valueOf("@OrganId");
                String roleId = user.valueOf("@RoleId");
                String userId = user.valueOf("@UserId");
                if (StringUtils.isNotBlank((CharSequence)organId)) {
                    PfOrganDo pfOrganDo = this.pfOrganMapper.getPfOrganById(organId);
                    if (null == pfOrganDo) continue;
                    HashMap<String, Object> organMap = new HashMap<String, Object>(2);
                    organMap.put("id", pfOrganDo.getOrganId());
                    organMap.put("name", pfOrganDo.getOrganName());
                    organMap.put("type", "organ");
                    organMap.put("isParent", false);
                    organMap.put("icon", "./../static/pfWorkflowForImage/img/organ.png");
                    participantMapList.add(organMap);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)roleId)) {
                    PfRoleDo pfRoleDo = this.pfRoleMapper.getPfRoleDoByRoleId(roleId);
                    if (null == pfRoleDo) continue;
                    HashMap<String, Object> roleMap = new HashMap<String, Object>(2);
                    roleMap.put("id", pfRoleDo.getRoleId());
                    roleMap.put("name", pfRoleDo.getRoleName());
                    roleMap.put("type", "role");
                    roleMap.put("isParent", false);
                    roleMap.put("icon", "./../static/pfWorkflowForImage/img/participant.png");
                    participantMapList.add(roleMap);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)userId) || null == (pfUserDo = this.pfUserMapper.getPfUserById(userId))) continue;
                HashMap<String, Object> userMap = new HashMap<String, Object>(2);
                userMap.put("id", pfUserDo.getUserId());
                userMap.put("name", pfUserDo.getUserName());
                userMap.put("type", "user");
                userMap.put("isParent", false);
                userMap.put("icon", "./../static/pfWorkflowForImage/img/user.png");
                participantMapList.add(userMap);
            }
        }
        return participantMapList;
    }

    private List<Map> getResourceMap(Node activity) {
        List resourceList = activity.selectNodes("Resources/Resource");
        if (!resourceList.isEmpty()) {
            return this.orgResourceMap(resourceList);
        }
        return null;
    }

    private List<Map> orgResourceMap(List<Node> resourceList) {
        LinkedList<Map> resourceMapList = new LinkedList<Map>();
        for (Node resource : resourceList) {
            HashMap<String, Object> resourceMap = new HashMap<String, Object>(2);
            resourceMap.put("id", resource.valueOf("@Id"));
            resourceMap.put("name", resource.valueOf("@Name"));
            resourceMap.put("visible", resource.valueOf("@Visible"));
            String resourceType = resource.valueOf("@Type");
            resourceMap.put("resourceType", resourceType);
            resourceMap.put("type", "resource");
            resourceMap.put("isParent", false);
            if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"0")) {
                List resourceChildrenMap = this.orgResourceMap(resource.selectNodes("Resource"));
                resourceMap.put("children", resourceChildrenMap);
                resourceMap.put("isParent", !resourceChildrenMap.isEmpty());
                resourceMap.put("open", true);
                resourceMap.put("type", "subMenu");
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/menu.png");
            } else if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"1")) {
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/dtbd.png");
            } else if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"2")) {
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/jsp.png");
            } else if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"3")) {
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/struts.png");
            } else if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"4")) {
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/servlet.png");
            } else if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"5")) {
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/action.png");
            } else if (StringUtils.equals((CharSequence)resourceType, (CharSequence)"6")) {
                resourceMap.put("icon", "./../static/pfWorkflowForImage/img/cxsj.png");
            }
            resourceMapList.add(resourceMap);
        }
        return resourceMapList;
    }

    public ResCommonResult addParticipant(String wfDefId, String activityId, String type, String participantIds) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            String[] participantIdList;
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            Element performer = (Element)activity.selectSingleNode("Performer");
            for (String participantId : participantIdList = participantIds.split(",")) {
                Element organ;
                Node node;
                if (StringUtils.equals((CharSequence)type, (CharSequence)"addOrgan")) {
                    node = activity.selectSingleNode("Performer/User[@OrganId='" + participantId + "']");
                    if (null != node) continue;
                    organ = performer.addElement("User");
                    organ.addAttribute("OrganId", participantId);
                    organ.addAttribute("UserId", "");
                    organ.addAttribute("RoleId", "");
                    continue;
                }
                if (StringUtils.equals((CharSequence)type, (CharSequence)"addRole")) {
                    node = activity.selectSingleNode("Performer/User[@RoleId='" + participantId + "']");
                    if (null != node) continue;
                    organ = performer.addElement("User");
                    organ.addAttribute("OrganId", "");
                    organ.addAttribute("UserId", "");
                    organ.addAttribute("RoleId", participantId);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)type, (CharSequence)"addUser") || null != (node = activity.selectSingleNode("Performer/User[@UserId='" + participantId + "']"))) continue;
                organ = performer.addElement("User");
                organ.addAttribute("OrganId", "");
                organ.addAttribute("UserId", participantId);
                organ.addAttribute("RoleId", "");
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            return ResCommonResult.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u6dfb\u52a0\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    public ResCommonResult deleteParticipant(String wfDefId, String activityId, String type, String participantId) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            Element performer = (Element)activity.selectSingleNode("Performer");
            String idType = StringUtils.equals((CharSequence)type, (CharSequence)"organ") ? "OrganId" : (StringUtils.equals((CharSequence)type, (CharSequence)"role") ? "RoleId" : "UserId");
            Node node = activity.selectSingleNode("Performer/User[@" + idType + "='" + participantId + "']");
            if (null != node) {
                performer.remove(node);
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            return ResCommonResult.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u5220\u9664\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult addResource(String wfDefId, String activityId, String subMenuId, String resourceIds, String visible) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            String[] resourceIdList = resourceIds.split(",");
            Node resourceNode = activity.selectSingleNode("Resources");
            List resourceList = resourceNode.selectNodes("Resource");
            for (String resourceId : resourceIdList) {
                if (null != this.getResourceNode(resourceId, resourceList)) continue;
                if (StringUtils.isNotBlank((CharSequence)subMenuId)) {
                    Node subMenuNode = this.getResourceNode(subMenuId, resourceList);
                    if (null == subMenuNode) continue;
                    this.addResourceToElement(wfDefId, activityId, (Element)subMenuNode, resourceIds, visible);
                    continue;
                }
                this.addResourceToElement(wfDefId, activityId, (Element)resourceNode, resourceIds, visible);
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            return ResCommonResult.success((String)"\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u6dfb\u52a0\u8d44\u6e90\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    private Node getResourceNode(String subMenuId, List<Node> resourceList) {
        for (Node resource : resourceList) {
            Node targetNode;
            if (StringUtils.equals((CharSequence)subMenuId, (CharSequence)resource.valueOf("@Id"))) {
                return resource;
            }
            Element resourceElement = (Element)resource;
            if (resourceElement.elements().isEmpty() || null == (targetNode = this.getResourceNode(subMenuId, resourceElement.elements()))) continue;
            return targetNode;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addResourceToElement(String wfDefId, String activityId, Element element, String resourceIds, String visible) {
        String[] resourceIdList;
        for (String resourceId : resourceIdList = resourceIds.split(",")) {
            PfResourceDo pfResourceDo;
            Node resourceNode = element.selectSingleNode("Resource[@Id='" + resourceId + "']");
            if (null == resourceNode && null != (pfResourceDo = this.pfResourceMapper.getPfResourceById(resourceId))) {
                Element resource = element.addElement("Resource");
                resource.addAttribute("Id", resourceId);
                resource.addAttribute("Name", pfResourceDo.getResourceName());
                resource.addAttribute("Type", pfResourceDo.getResourceType().toString());
                resource.addAttribute("Visible", visible);
            }
            PfResourcePartitionDo pfResourcePartitionDo = new PfResourcePartitionDo();
            pfResourcePartitionDo.setResourceId(resourceId);
            List pfResourcePartitionDoList = this.pfPartitionMapper.getPfResourcePartitionList(pfResourcePartitionDo);
            if (pfResourcePartitionDoList.isEmpty()) continue;
            for (PfResourcePartitionDo partitionDo : pfResourcePartitionDoList) {
                PfAuthorizeDo pfAuthorizeDo = new PfAuthorizeDo();
                pfAuthorizeDo.setAuthorizeId(StrUtil.getUUID32());
                pfAuthorizeDo.setAuthorizeObjType(Integer.valueOf(0));
                pfAuthorizeDo.setUndertakeWorkflowId(wfDefId);
                pfAuthorizeDo.setUndertakeActivityId(activityId);
                pfAuthorizeDo.setAuthorizeObjId(partitionDo.getPartitionId());
                this.pfAuthorizeMapper.insertPfAuthorize(pfAuthorizeDo);
            }
        }
    }

    public ResCommonResult addSubMenu(String wfDefId, String activityId, String parentMenuId, String subMenuName, String visible) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)parentMenuId)) {
                List resourceList = activity.selectNodes("Resources/Resource");
                Node subMenuNode = this.getResourceNode(parentMenuId, resourceList);
                if (null != subMenuNode) {
                    this.addSubMenuToElement((Element)subMenuNode, subMenuName, visible);
                }
            } else {
                Node resourceNode = activity.selectSingleNode("Resources");
                if (null != resourceNode) {
                    this.addSubMenuToElement((Element)resourceNode, subMenuName, visible);
                }
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            return ResCommonResult.success((String)"\u6dfb\u52a0\u5b50\u83dc\u5355\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u6dfb\u52a0\u5b50\u83dc\u5355\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    private void addSubMenuToElement(Element element, String subMenuName, String visible) {
        Element subMenu = element.addElement("Resource");
        subMenu.addAttribute("Id", StrUtil.getUUID32());
        subMenu.addAttribute("Name", subMenuName);
        subMenu.addAttribute("Type", "0");
        subMenu.addAttribute("Visible", visible);
    }

    public ResCommonResult updateResource(String wfDefId, String activityId, String subMenuId, String resourceId, String visible) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            Node resourceNode;
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)subMenuId)) {
                List resourceList = activity.selectNodes("Resources/Resource");
                resourceNode = this.getResourceNode(subMenuId, resourceList).selectSingleNode("Resource[@Id='" + resourceId + "']");
            } else {
                resourceNode = activity.selectSingleNode("Resources/Resource[@Id='" + resourceId + "']");
            }
            if (null != resourceNode) {
                Element resourceElement = (Element)resourceNode;
                resourceElement.addAttribute("Visible", visible);
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            return ResCommonResult.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u4fee\u6539\u8d44\u6e90\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    public ResCommonResult updateSubMenu(String wfDefId, String activityId, String currId, String subMenuId, String subMenuName, String visible) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            Node subMenuNode;
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)subMenuId)) {
                List resourceList = activity.selectNodes("Resources/Resource");
                subMenuNode = this.getResourceNode(subMenuId, resourceList).selectSingleNode("Resource[@Id='" + currId + "']");
            } else {
                subMenuNode = activity.selectSingleNode("Resources/Resource[@Id='" + currId + "']");
            }
            if (null != subMenuNode) {
                Element subMenuElement = (Element)subMenuNode;
                subMenuElement.addAttribute("Name", subMenuName);
                subMenuElement.addAttribute("Visible", visible);
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            return ResCommonResult.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u4fee\u6539\u8d44\u6e90\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    public ResCommonResult removeResourceAndMenu(String wfDefId, String activityId, String currId, String subMenuId) {
        if (StringUtils.isBlank((CharSequence)wfDefId)) {
            return ResCommonResult.error((String)"\u4f20\u5165\u7684\u5de5\u4f5c\u6d41\u5b9a\u4e49id\u4e3a\u7a7a\uff01");
        }
        PfWorkflowDefinitionDo pfWorkflowDefinitionDo = this.pfWorkflowDefinitionMapper.getWfDefById(wfDefId);
        if (null == pfWorkflowDefinitionDo) {
            return ResCommonResult.error((String)"\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5b9a\u4e49\u5bf9\u8c61\uff01\uff01");
        }
        try {
            Node currNode;
            Document documentXml = DocumentHelper.parseText((String)pfWorkflowDefinitionDo.getWorkflowXml());
            if (StringUtils.isBlank((CharSequence)activityId)) {
                return ResCommonResult.error((String)"\u8282\u70b9id\u4e3a\u7a7a\uff01");
            }
            Node activity = documentXml.selectSingleNode("//WorkflowProcess/Activities/Activity[@Id='" + activityId + "']");
            if (null == activity) {
                return ResCommonResult.error((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8282\u70b9\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)subMenuId)) {
                List resourceList = activity.selectNodes("Resources/Resource");
                currNode = this.getResourceNode(subMenuId, resourceList).selectSingleNode("Resource[@Id='" + currId + "']");
            } else {
                currNode = activity.selectSingleNode("Resources/Resource[@Id='" + currId + "']");
            }
            if (null != currNode) {
                currNode.getParent().remove(currNode);
            }
            documentXml.setXMLEncoding("UTF-8");
            pfWorkflowDefinitionDo.setWorkflowXml(documentXml.asXML());
            pfWorkflowDefinitionDo.setModifyTime(DateUtil.now());
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
            PfResourcePartitionDo pfResourcePartitionDo = new PfResourcePartitionDo();
            pfResourcePartitionDo.setResourceId(currId);
            List pfResourcePartitionDoList = this.pfPartitionMapper.getPfResourcePartitionList(pfResourcePartitionDo);
            if (!pfResourcePartitionDoList.isEmpty()) {
                for (PfResourcePartitionDo partitionDo : pfResourcePartitionDoList) {
                    HashMap<String, String> param = new HashMap<String, String>(2);
                    param.put("authorizeObjId", partitionDo.getPartitionId());
                    param.put("undertakeWorkflowId", wfDefId);
                    param.put("undertakeActivityId", activityId);
                    this.pfAuthorizeMapper.deletePfAuthorize(param);
                }
            }
            return ResCommonResult.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error((String)"\u5220\u9664\u8d44\u6e90\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u540e\u53f0");
        }
    }

    public Object getPfWfResourceAuthorizeList(int page, int limit, String wfDefId, String activityId, String resourceId, String partitionName) {
        if (StringUtils.isNotBlank((CharSequence)resourceId)) {
            PageHelper.startPage((int)page, (int)limit);
            PfResourcePartitionDo pfResourcePartitionDo = new PfResourcePartitionDo();
            pfResourcePartitionDo.setResourceId(resourceId);
            if (StringUtils.isNotBlank((CharSequence)partitionName)) {
                pfResourcePartitionDo.setPartitionName(partitionName);
            }
            List pfResourcePartitionList = this.pfPartitionMapper.getPfResourcePartitionList(pfResourcePartitionDo);
            LinkedList pfPartitionAuthorizationList = new LinkedList();
            for (PfResourcePartitionDo partitionDo : pfResourcePartitionList) {
                HashMap<String, Object> partitionAuthorizeMap = new HashMap<String, Object>(2);
                try {
                    partitionAuthorizeMap.put("partitionName", partitionDo.getPartitionName());
                    partitionAuthorizeMap.put("partitionId", partitionDo.getPartitionId());
                    partitionAuthorizeMap.put("partitionType", partitionDo.getPartitionType());
                    partitionAuthorizeMap.put("undertakeWorkflowId", wfDefId);
                    partitionAuthorizeMap.put("undertakeActivityId", activityId);
                    PfAuthorizeDo pfAuthorizeDo = new PfAuthorizeDo();
                    pfAuthorizeDo.setUndertakeWorkflowId(wfDefId);
                    pfAuthorizeDo.setUndertakeActivityId(activityId);
                    pfAuthorizeDo.setAuthorizeObjId(partitionDo.getPartitionId());
                    List pfAuthorizeDoList = this.pfAuthorizeMapper.getPfAuthorizeDoList(pfAuthorizeDo);
                    if (!pfAuthorizeDoList.isEmpty()) {
                        PfAuthorizeDo pfAuthorizeDo1 = (PfAuthorizeDo)pfAuthorizeDoList.get(0);
                        partitionAuthorizeMap.put("operateType", pfAuthorizeDo1.getOperateType());
                        partitionAuthorizeMap.put("authorizeId", pfAuthorizeDo1.getAuthorizeId());
                    } else {
                        partitionAuthorizeMap.put("operateType", "");
                        partitionAuthorizeMap.put("authorizeId", "");
                    }
                    pfPartitionAuthorizationList.add(partitionAuthorizeMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            PageInfo pageInfo = new PageInfo(pfPartitionAuthorizationList);
            return new LayuiPageResultMap((Object)pageInfo.getList(), pageInfo.getTotal());
        }
        return null;
    }

    public ResCommonResult updateAuthorizeResource(String authorizeId, Integer operateType, String partitionId, String undertakeWorkflowId, String undertakeActivityId) {
        if (StringUtils.isNotBlank((CharSequence)authorizeId)) {
            PfAuthorizeDo pfAuthorizeDo = this.pfAuthorizeMapper.getPfAuthorizeDoById(authorizeId);
            if (null != pfAuthorizeDo) {
                pfAuthorizeDo.setOperateType(operateType);
                this.pfAuthorizeMapper.updatePfAuthorize(pfAuthorizeDo);
            }
        } else {
            PfAuthorizeDo pfAuthorizeDo = new PfAuthorizeDo();
            pfAuthorizeDo.setAuthorizeId(StrUtil.getUUID32());
            pfAuthorizeDo.setAuthorizeObjId(partitionId);
            pfAuthorizeDo.setUndertakeWorkflowId(undertakeWorkflowId);
            pfAuthorizeDo.setUndertakeActivityId(undertakeActivityId);
            pfAuthorizeDo.setAuthorizeObjType(Integer.valueOf(0));
            pfAuthorizeDo.setOperateType(operateType);
            this.pfAuthorizeMapper.insertPfAuthorize(pfAuthorizeDo);
        }
        return ResCommonResult.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    public ResCommonResult insertPfWfDef(PfWorkflowDefinitionDo pfWorkflowDefinitionDo) {
        return null;
    }

    public ResCommonResult updatePfWfDef(PfWorkflowDefinitionDo pfWorkflowDefinitionDo) {
        try {
            this.pfWorkflowDefinitionMapper.updatePfWorkflowDefinition(pfWorkflowDefinitionDo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResCommonResult.error();
        }
        return ResCommonResult.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }
}

