/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.config.security.YunNanPasswordEncoder;
import cn.gtmap.realestate.core.entity.PfOrganDo;
import cn.gtmap.realestate.core.entity.PfRoleDo;
import cn.gtmap.realestate.core.entity.PfUserDo;
import cn.gtmap.realestate.core.entity.PfUserOrganRelDo;
import cn.gtmap.realestate.core.entity.PfUserRoleRelDo;
import cn.gtmap.realestate.core.entity.PfUserVo;
import cn.gtmap.realestate.core.mapper.PfOrganMapper;
import cn.gtmap.realestate.core.mapper.PfRoleMapper;
import cn.gtmap.realestate.core.mapper.PfUserMapper;
import cn.gtmap.realestate.core.model.LayuiPageResultMap;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.model.UserInfo;
import cn.gtmap.realestate.core.service.PfUserService;
import cn.gtmap.realestate.util.Base64Util;
import cn.gtmap.realestate.util.ConfigConstants;
import cn.gtmap.realestate.util.Md5Util;
import cn.gtmap.realestate.util.SessionUtils;
import cn.gtmap.realestate.util.StrUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class PfUserServiceImpl
implements PfUserService {
    @Autowired
    private PfUserMapper pfUserMapper;
    @Autowired
    private PfRoleMapper pfRoleMapper;
    @Autowired
    private PfOrganMapper pfOrganMapper;
    @Value(value="${password.encode.type:DEFAULT}")
    private String encodeType;
    @Value(value="${password.encode.yunnan.url:}")
    private String encodeUrl;

    public String toPfUserList(Model model) {
        model.addAttribute("organList", (Object)this.pfOrganMapper.getPfOrganList());
        UserInfo userInfo = SessionUtils.getCurrentUser();
        if (null != userInfo) {
            model.addAttribute("isAdmin", (Object)userInfo.isAdmin());
            model.addAttribute("currUserId", (Object)userInfo.getId());
        }
        return "user/pfUserList";
    }

    public String toPfUserForm(Model model, String type, String userId) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)ConfigConstants.OPERATION_MODIFY)) {
            PfUserDo userInfo = this.pfUserMapper.getPfUserById(userId);
            PfUserVo pfUserVo = new PfUserVo();
            BeanUtils.copyProperties((Object)userInfo, (Object)pfUserVo);
            pfUserVo.setUserPhoto(Base64Util.encodeByteToBase64Str((byte[])userInfo.getUserPhoto()));
            pfUserVo.setUserSign(Base64Util.encodeByteToBase64Str((byte[])userInfo.getUserSign()));
            model.addAttribute("userInfo", (Object)pfUserVo);
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("userId", userId);
            List currPfRoleList = this.pfRoleMapper.getPfRoleList(param);
            String[] currRoleIdList = new String[currPfRoleList.size()];
            for (int i = 0; i < currPfRoleList.size(); ++i) {
                currRoleIdList[i] = ((PfRoleDo)currPfRoleList.get(i)).getRoleId();
            }
            model.addAttribute("currRoleIdList", (Object)currRoleIdList);
            List currOrganList = this.pfOrganMapper.getPfOrganListByUserId(userId);
            String[] currOrganIdList = new String[currOrganList.size()];
            for (int i = 0; i < currOrganList.size(); ++i) {
                currOrganIdList[i] = ((PfOrganDo)currOrganList.get(i)).getOrganId();
            }
            model.addAttribute("currOrganList", (Object)currOrganIdList);
        }
        model.addAttribute("roleList", (Object)this.pfRoleMapper.getPfRoleList(null));
        model.addAttribute("organList", (Object)this.pfOrganMapper.getPfOrganList());
        model.addAttribute("type", (Object)type);
        return "user/pfUserForm";
    }

    public Object getPfUserList(int page, int limit, String userNo, String userName, String userType, String organId) {
        PageHelper.startPage((int)page, (int)limit);
        Map param = this.orgParam(userNo, userName, userType, organId);
        List userDoList = this.pfUserMapper.getPfUserList(param);
        this.getOrganInfo(userDoList);
        PageInfo pageInfo = new PageInfo(userDoList);
        return new LayuiPageResultMap((Object)pageInfo.getList(), pageInfo.getTotal());
    }

    private void getOrganInfo(List<Map<String, String>> userDoList) {
        if (!userDoList.isEmpty()) {
            for (Map<String, String> map : userDoList) {
                List organList;
                String userId = map.get("userId");
                if (!StringUtils.isNotBlank((CharSequence)userId) || (organList = this.pfOrganMapper.getPfOrganListByUserId(userId)).isEmpty()) continue;
                StringBuilder orgName = new StringBuilder();
                for (int i = 0; i < organList.size(); ++i) {
                    orgName.append(((PfOrganDo)organList.get(i)).getOrganName());
                    orgName.append(i == organList.size() - 1 ? "" : ",");
                }
                map.put("organName", orgName.toString());
            }
        }
    }

    private Map<String, Object> orgParam(String userNo, String userName, String userType, String organId) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        if (StringUtils.isNotBlank((CharSequence)userNo)) {
            param.put("userNo", userNo);
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            param.put("userName", userName);
        }
        if (StringUtils.isNotBlank((CharSequence)userType)) {
            param.put("userType", userType);
        }
        if (StringUtils.isNotBlank((CharSequence)organId)) {
            param.put("organId", organId);
        }
        return param;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult insertPfUser(PfUserVo pfUserVo) {
        pfUserVo.setUserId(StrUtil.getUUID32());
        if (StringUtils.equals((CharSequence)this.encodeType, (CharSequence)"YUNNAN")) {
            try {
                pfUserVo.setLoginPassword(new YunNanPasswordEncoder(this.encodeUrl).encode((CharSequence)Md5Util.Build((String)pfUserVo.getLoginPassword())));
            }
            catch (Exception e) {
                return ResCommonResult.error((String)("\u8bf7\u6c42\u52a0\u5bc6\u673a\u5931\u8d25\uff01" + e));
            }
        } else {
            pfUserVo.setLoginPassword(Md5Util.Build((String)pfUserVo.getLoginPassword()));
        }
        PfUserDo pfUserDo = new PfUserDo();
        BeanUtils.copyProperties((Object)pfUserVo, (Object)pfUserDo);
        if (StringUtils.isNotBlank((CharSequence)pfUserVo.getUserPhoto())) {
            pfUserDo.setUserPhoto(Base64Util.decodeBase64StrToByte((String)pfUserVo.getUserPhoto()));
        }
        if (StringUtils.isNotBlank((CharSequence)pfUserVo.getUserSign())) {
            pfUserDo.setUserSign(Base64Util.decodeBase64StrToByte((String)pfUserVo.getUserSign()));
        }
        Boolean result = this.pfUserMapper.insertPfUser(pfUserDo);
        String message = "";
        if (result.booleanValue()) {
            Boolean flag;
            message = "\u65b0\u589e\u7528\u6237\u4fe1\u606f\u6210\u529f\uff01";
            if (StringUtils.isNotBlank((CharSequence)pfUserVo.getOrganIds())) {
                String[] organIdList = pfUserVo.getOrganIds().split(",");
                flag = true;
                for (String organId : organIdList) {
                    PfUserOrganRelDo pfUserOrganRelDo = new PfUserOrganRelDo();
                    pfUserOrganRelDo.setOrganId(organId);
                    pfUserOrganRelDo.setUserId(pfUserVo.getUserId());
                    pfUserOrganRelDo.setUdrId(StrUtil.getUUID32());
                    result = this.pfUserMapper.insertPfUserOrganRel(pfUserOrganRelDo);
                    if (result.booleanValue()) continue;
                    flag = false;
                }
                message = message + (flag != false ? "" : "\n\u65b0\u589e\u7528\u6237-\u90e8\u95e8\u5173\u7cfb\u5931\u8d25\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)pfUserVo.getRoleIds())) {
                String[] roleIdList = pfUserVo.getRoleIds().split(",");
                flag = true;
                for (String roleId : roleIdList) {
                    PfUserRoleRelDo pfUserRoleRelDo = new PfUserRoleRelDo();
                    pfUserRoleRelDo.setUserId(pfUserVo.getUserId());
                    pfUserRoleRelDo.setRoleId(roleId);
                    pfUserRoleRelDo.setUrrId(StrUtil.getUUID32());
                    result = this.pfRoleMapper.insertPfUserRoleRel(pfUserRoleRelDo);
                    if (result.booleanValue()) continue;
                    flag = false;
                }
                message = message + (flag != false ? "" : "\n\u65b0\u589e\u7528\u6237\u89d2\u8272\u5931\u8d25\uff01");
            }
        } else {
            message = "\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01";
        }
        return ResCommonResult.success((String)message);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult updatePfUser(PfUserVo pfUserVo) {
        String loginPwd;
        PfUserDo currUser = this.pfUserMapper.getPfUserById(pfUserVo.getUserId());
        if (null != currUser && StringUtils.isNotBlank((CharSequence)(loginPwd = currUser.getLoginPassword())) && !StringUtils.equals((CharSequence)loginPwd, (CharSequence)pfUserVo.getLoginPassword())) {
            if (StringUtils.equals((CharSequence)this.encodeType, (CharSequence)"YUNNAN")) {
                try {
                    pfUserVo.setLoginPassword(new YunNanPasswordEncoder(this.encodeUrl).encode((CharSequence)Md5Util.Build((String)pfUserVo.getLoginPassword())));
                }
                catch (Exception e) {
                    return ResCommonResult.error((String)("\u8bf7\u6c42\u52a0\u5bc6\u673a\u5931\u8d25\uff01" + e));
                }
            } else {
                pfUserVo.setLoginPassword(Md5Util.Build((String)pfUserVo.getLoginPassword()));
            }
        }
        PfUserDo pfUserDo = new PfUserDo();
        BeanUtils.copyProperties((Object)pfUserVo, (Object)pfUserDo);
        if (StringUtils.isNotBlank((CharSequence)pfUserVo.getUserPhoto())) {
            pfUserDo.setUserPhoto(Base64Util.decodeBase64StrToByte((String)pfUserVo.getUserPhoto()));
        }
        if (StringUtils.isNotBlank((CharSequence)pfUserVo.getUserSign())) {
            pfUserDo.setUserSign(Base64Util.decodeBase64StrToByte((String)pfUserVo.getUserSign()));
        }
        Boolean result = this.pfUserMapper.updatePfUser(pfUserDo);
        String message = "";
        if (result.booleanValue()) {
            message = "\u4fee\u6539\u7528\u6237\u4fe1\u606f\u6210\u529f\uff01";
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("userId", pfUserVo.getUserId());
            List pfUserOrganRelDoList = this.pfUserMapper.getPfUserOrganRel(param);
            Boolean flag = true;
            PfUserOrganRelDo pfUserOrganRelDo = new PfUserOrganRelDo();
            pfUserOrganRelDo.setUserId(pfUserVo.getUserId());
            if (null != pfUserOrganRelDoList && pfUserOrganRelDoList.size() > 0) {
                flag = this.pfUserMapper.deletePfUserOrganRel(pfUserOrganRelDo);
            }
            if (StringUtils.isNotBlank((CharSequence)pfUserVo.getOrganIds())) {
                String[] organIdList;
                for (String organId : organIdList = pfUserVo.getOrganIds().split(",")) {
                    pfUserOrganRelDo.setOrganId(organId);
                    pfUserOrganRelDo.setUdrId(StrUtil.getUUID32());
                    result = this.pfUserMapper.insertPfUserOrganRel(pfUserOrganRelDo);
                    if (result.booleanValue()) continue;
                    flag = false;
                }
            }
            message = message + (flag != false ? "" : "\n\u4fee\u6539\u7528\u6237-\u90e8\u95e8\u5173\u7cfb\u5931\u8d25\uff01");
            List pfUserRoleRelDoList = this.pfRoleMapper.getPfUserRoleRelList(param);
            flag = true;
            PfUserRoleRelDo pfUserRoleRelDo = new PfUserRoleRelDo();
            pfUserRoleRelDo.setUserId(pfUserVo.getUserId());
            if (null != pfUserRoleRelDoList && pfUserRoleRelDoList.size() > 0) {
                flag = this.pfRoleMapper.deletePfUserRoleRel(pfUserRoleRelDo);
            }
            if (StringUtils.isNotBlank((CharSequence)pfUserVo.getRoleIds())) {
                String[] roleIdList;
                for (String roleId : roleIdList = pfUserVo.getRoleIds().split(",")) {
                    pfUserRoleRelDo.setRoleId(roleId);
                    pfUserRoleRelDo.setUrrId(StrUtil.getUUID32());
                    result = this.pfRoleMapper.insertPfUserRoleRel(pfUserRoleRelDo);
                    if (result.booleanValue()) continue;
                    flag = false;
                }
            }
            message = message + (flag != false ? "" : "\n\u4fee\u6539\u7528\u6237-\u89d2\u8272\u5173\u7cfb\u5931\u8d25\uff01");
        } else {
            message = "\u4fee\u6539\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01";
        }
        return ResCommonResult.success((String)message);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deletePfUser(PfUserVo pfUserVo) {
        String message = "";
        Boolean result = this.pfUserMapper.deletePfUser(pfUserVo);
        if (result.booleanValue()) {
            message = "\u5220\u9664\u7528\u6237\u4fe1\u606f\u6210\u529f\uff01";
            if (StringUtils.isNotBlank((CharSequence)pfUserVo.getOrganIds())) {
                PfUserOrganRelDo pfUserOrganRelDo = new PfUserOrganRelDo();
                pfUserOrganRelDo.setUserId(pfUserVo.getUserId());
                message = message + (this.pfUserMapper.deletePfUserOrganRel(pfUserOrganRelDo) != false ? "" : "\n\u5220\u9664\u7528\u6237-\u90e8\u95e8\u5173\u7cfb\u5931\u8d25\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)pfUserVo.getRoleIds())) {
                PfUserRoleRelDo pfUserRoleRelDo = new PfUserRoleRelDo();
                pfUserRoleRelDo.setUserId(pfUserVo.getUserId());
                message = message + (this.pfRoleMapper.deletePfUserRoleRel(pfUserRoleRelDo) != false ? "" : "\n\u5220\u9664\u7528\u6237-\u89d2\u8272\u5173\u7cfb\u5931\u8d25\uff01");
            }
        } else {
            message = "\u5220\u9664\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01";
        }
        return ResCommonResult.success((String)message);
    }
}

