/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.entity.PfAuthorizeDo;
import cn.gtmap.realestate.core.entity.PfMenuDo;
import cn.gtmap.realestate.core.entity.PfRoleDo;
import cn.gtmap.realestate.core.entity.PfRoleVo;
import cn.gtmap.realestate.core.entity.PfUserRoleRelDo;
import cn.gtmap.realestate.core.mapper.PfAuthorizeMapper;
import cn.gtmap.realestate.core.mapper.PfMenuMapper;
import cn.gtmap.realestate.core.mapper.PfRoleMapper;
import cn.gtmap.realestate.core.mapper.PfUserMapper;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.service.PfRoleService;
import cn.gtmap.realestate.util.ConfigConstants;
import cn.gtmap.realestate.util.StrUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.DozerBeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class PfRoleServiceImpl
implements PfRoleService {
    @Autowired
    private PfRoleMapper pfRoleMapper;
    @Autowired
    private PfAuthorizeMapper pfAuthorizeMapper;
    @Autowired
    private PfUserMapper pfUserMapper;
    @Autowired
    private PfMenuMapper pfMenuMapper;
    @Resource(name="org.dozer.Mapper")
    private DozerBeanMapper dozerBeanMapper;

    public String toPfRoleList(Model model) {
        return "role/pfRoleList";
    }

    public String toPfRoleForm(Model model, String roleId, String type) {
        model.addAttribute("type", (Object)type);
        if (StringUtils.equals((CharSequence)type, (CharSequence)ConfigConstants.OPERATION_MODIFY)) {
            model.addAttribute("roleInfo", (Object)this.pfRoleMapper.getPfRoleDoByRoleId(roleId));
        } else {
            model.addAttribute("roleInfo", (Object)new PfRoleDo());
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        model.addAttribute("userList", (Object)this.pfUserMapper.getPfUserList(paramMap));
        if (StringUtils.isNotBlank((CharSequence)roleId)) {
            paramMap.put("roleId", roleId);
            List currUserList = this.pfUserMapper.getPfUserList(paramMap);
            String[] userIdList = new String[currUserList.size()];
            for (int i = 0; i < currUserList.size(); ++i) {
                userIdList[i] = (String)((Map)currUserList.get(i)).get("userId");
            }
            model.addAttribute("currUserList", (Object)userIdList);
        }
        return "role/pfRoleForm";
    }

    public ResCommonResult getPfRoleList() {
        return ResCommonResult.success((Object)this.pfRoleMapper.getPfRoleList(null));
    }

    public List<Map> getPfRoleMenuJson(String roleId) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        LinkedList<Map> resultList = new LinkedList<Map>();
        if (StringUtils.isNotBlank((CharSequence)roleId)) {
            param.put("roleId", roleId);
            List pfRoleMenuMapList = this.pfRoleMapper.getPfRoleMenuList(param);
            Map rootRoleMenu = null;
            for (Map pfRoleMenuMap : pfRoleMenuMapList) {
                if (!StringUtils.equals((CharSequence)((CharSequence)pfRoleMenuMap.get("allMenuId")), (CharSequence)ConfigConstants.STRING_ONE)) continue;
                rootRoleMenu = pfRoleMenuMap;
            }
            if (null != rootRoleMenu) {
                Map propertyMap = this.getPropertyMap(rootRoleMenu);
                propertyMap.put("children", this.orgPfRoleMenuTree(pfRoleMenuMapList, (String)rootRoleMenu.get("allMenuId")));
                resultList.add(propertyMap);
                return resultList;
            }
        }
        return null;
    }

    private List<Map> orgPfRoleMenuTree(List<Map<String, String>> pfRoleMenuMapList, String menuParentId) {
        LinkedList<Map> resultList = new LinkedList<Map>();
        for (int i = 0; i < pfRoleMenuMapList.size(); ++i) {
            Map<String, String> currMap = pfRoleMenuMapList.get(i);
            if (!StringUtils.equals((CharSequence)currMap.get("allMenuParentId"), (CharSequence)menuParentId)) continue;
            Map propertyMap = this.getPropertyMap(currMap);
            List children = this.orgPfRoleMenuTree(pfRoleMenuMapList, currMap.get("allMenuId"));
            if (children.size() != 0) {
                propertyMap.put("isParent", true);
            }
            propertyMap.put("children", children);
            resultList.add(propertyMap);
        }
        return resultList;
    }

    private Map<String, Object> getPropertyMap(Map<String, String> param) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
        propertyMap.put("id", param.get("allMenuId"));
        propertyMap.put("name", param.get("menuName"));
        propertyMap.put("open", true);
        propertyMap.put("isParent", false);
        propertyMap.put("checked", StringUtils.isNotBlank((CharSequence)param.get("audMenuId")));
        return propertyMap;
    }

    public ResCommonResult insertMenuOfRole(PfRoleVo pfRoleVo) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("menuId", pfRoleVo.getMenuId());
        param.put("type", "up");
        List priorNodeList = this.pfRoleMapper.getMenuNodeList(param);
        if (priorNodeList.size() != 0) {
            for (Map priorNode : priorNodeList) {
                this.insertOrUpdateNode((String)priorNode.get("menuId"), pfRoleVo.getRoleId());
            }
        }
        if (pfRoleVo.getHavingChildren().booleanValue()) {
            param.put("type", "down");
            List backNodeList = this.pfRoleMapper.getMenuNodeList(param);
            for (Map backNode : backNodeList) {
                this.insertOrUpdateNode((String)backNode.get("menuId"), pfRoleVo.getRoleId());
            }
        }
        return ResCommonResult.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public void insertOrUpdateNode(String menuId, String roleId) {
        PfAuthorizeDo pfAuthorizeDo = new PfAuthorizeDo();
        pfAuthorizeDo.setUndertakerId(roleId);
        pfAuthorizeDo.setAuthorizeObjId(menuId);
        List pfAuthorizeDoList = this.pfAuthorizeMapper.getPfAuthorizeDoList(pfAuthorizeDo);
        pfAuthorizeDo.setMenuVisible(Integer.valueOf(this.havingChildren(menuId, roleId) != false ? 2 : 1));
        if (!pfAuthorizeDoList.isEmpty()) {
            this.pfAuthorizeMapper.updatePfAuthorize(pfAuthorizeDo);
        } else {
            pfAuthorizeDo.setAuthorizeId(StrUtil.getUUID32());
            pfAuthorizeDo.setAuthorizeObjType(Integer.valueOf(1));
            this.pfAuthorizeMapper.insertPfAuthorize(pfAuthorizeDo);
        }
    }

    private Boolean havingChildren(String menuId, String roleId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("menuId", menuId);
        param.put("roleId", roleId);
        List pfAuthorizeDoList = this.pfAuthorizeMapper.getPfAuthorizeChildren(param);
        return pfAuthorizeDoList.size() != 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deleteMenuOfRole(PfRoleVo pfRoleVo) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("menuId", pfRoleVo.getMenuId());
        param.put("type", "up");
        PfAuthorizeDo pfAuthorizeDo = new PfAuthorizeDo();
        pfAuthorizeDo.setMenuVisible(Integer.valueOf(0));
        pfAuthorizeDo.setUndertakerId(pfRoleVo.getRoleId());
        pfAuthorizeDo.setAuthorizeObjId(pfRoleVo.getMenuId());
        this.pfAuthorizeMapper.updatePfAuthorize(pfAuthorizeDo);
        List priorNodeList = this.pfRoleMapper.getMenuNodeList(param);
        for (Map priorNode : priorNodeList) {
            if (StringUtils.equals((CharSequence)((CharSequence)priorNode.get("menuId")), (CharSequence)pfRoleVo.getMenuId()) || !this.havingChildren((String)priorNode.get("menuId"), pfRoleVo.getRoleId()).booleanValue()) continue;
            HashMap childrenParam = new HashMap(1);
            childrenParam.put("menuId", priorNode.get("menuId"));
            childrenParam.put("roleId", pfRoleVo.getRoleId());
            List pfAuthorizeDoList = this.pfAuthorizeMapper.getPfAuthorizeChildren(childrenParam);
            Boolean flag = false;
            for (PfAuthorizeDo parentNode : pfAuthorizeDoList) {
                if (parentNode.getMenuVisible() == 0) continue;
                flag = true;
                break;
            }
            if (flag.booleanValue()) continue;
            PfAuthorizeDo pfAuthorizeDo1 = new PfAuthorizeDo();
            pfAuthorizeDo1.setMenuVisible(Integer.valueOf(0));
            pfAuthorizeDo1.setUndertakerId(pfRoleVo.getRoleId());
            pfAuthorizeDo1.setAuthorizeObjId((String)priorNode.get("menuId"));
            this.pfAuthorizeMapper.updatePfAuthorize(pfAuthorizeDo1);
        }
        if (pfRoleVo.getHavingChildren().booleanValue()) {
            HashMap<String, String> childrenParam = new HashMap<String, String>(1);
            childrenParam.put("menuId", pfRoleVo.getMenuId());
            childrenParam.put("roleId", pfRoleVo.getRoleId());
            List pfAuthorizeDoList = this.pfAuthorizeMapper.getPfAuthorizeChildren(childrenParam);
            for (PfAuthorizeDo parent : pfAuthorizeDoList) {
                this.deletePfAuthorizeTree(parent);
            }
        }
        return ResCommonResult.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private void deletePfAuthorizeTree(PfAuthorizeDo parent) {
        HashMap<String, String> childrenParam = new HashMap<String, String>(1);
        childrenParam.put("menuId", parent.getAuthorizeObjId());
        childrenParam.put("roleId", parent.getUndertakerId());
        List pfAuthorizeDoList = this.pfAuthorizeMapper.getPfAuthorizeChildren(childrenParam);
        if (pfAuthorizeDoList.size() != 0) {
            for (PfAuthorizeDo children : pfAuthorizeDoList) {
                this.deletePfAuthorizeTree(children);
            }
        }
        parent.setMenuVisible(Integer.valueOf(0));
        this.pfAuthorizeMapper.updatePfAuthorize(parent);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult insertPfRole(PfRoleVo pfRoleVo) {
        String message = "";
        PfRoleDo pfRoleDo = new PfRoleDo();
        this.dozerBeanMapper.map((Object)pfRoleVo, (Object)pfRoleDo);
        pfRoleDo.setRoleId(StrUtil.getUUID32());
        message = message + (this.pfRoleMapper.insertPfRole(pfRoleDo) != false ? "\u65b0\u589e\u89d2\u8272\u6210\u529f\uff01" : "\u65b0\u589e\u89d2\u8272\u5931\u8d25\uff01");
        if (StringUtils.isNotBlank((CharSequence)pfRoleVo.getUserIds())) {
            String[] userIdList = pfRoleVo.getUserIds().split(",");
            PfUserRoleRelDo pfUserRoleRelDo = new PfUserRoleRelDo();
            pfUserRoleRelDo.setRoleId(pfRoleDo.getRoleId());
            for (String userId : userIdList) {
                pfUserRoleRelDo.setUserId(userId);
                pfUserRoleRelDo.setUrrId(StrUtil.getUUID32());
                this.pfRoleMapper.insertPfUserRoleRel(pfUserRoleRelDo);
            }
        }
        PfAuthorizeDo pfAuthorizeDo = new PfAuthorizeDo();
        pfAuthorizeDo.setUndertakerId(pfRoleDo.getRoleId());
        List pfMenuDoList = this.pfMenuMapper.getPfMenuList(null);
        for (PfMenuDo pfMenuDo : pfMenuDoList) {
            pfAuthorizeDo.setAuthorizeId(StrUtil.getUUID32());
            pfAuthorizeDo.setAuthorizeObjType(Integer.valueOf(1));
            pfAuthorizeDo.setAuthorizeObjId(pfMenuDo.getMenuId());
            pfAuthorizeDo.setMenuVisible(Integer.valueOf(0));
            this.pfAuthorizeMapper.insertPfAuthorize(pfAuthorizeDo);
        }
        return ResCommonResult.success((String)message);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult updatePfRole(PfRoleVo pfRoleVo) {
        String message = "";
        PfRoleDo pfRoleDo = new PfRoleDo();
        this.dozerBeanMapper.map((Object)pfRoleVo, (Object)pfRoleDo);
        message = message + (this.pfRoleMapper.updatePfRole(pfRoleDo) != false ? "\u4fee\u6539\u89d2\u8272\u6210\u529f\uff01" : "\u4fee\u6539\u89d2\u8272\u5931\u8d25\uff01");
        if (null != pfRoleVo.getUserIds()) {
            String[] userIdList;
            PfUserRoleRelDo pfUserRoleRelDo = new PfUserRoleRelDo();
            pfUserRoleRelDo.setRoleId(pfRoleDo.getRoleId());
            this.pfRoleMapper.deletePfUserRoleRel(pfUserRoleRelDo);
            for (String userId : userIdList = pfRoleVo.getUserIds().split(",")) {
                pfUserRoleRelDo.setUserId(userId);
                pfUserRoleRelDo.setUrrId(StrUtil.getUUID32());
                this.pfRoleMapper.insertPfUserRoleRel(pfUserRoleRelDo);
            }
        }
        return ResCommonResult.success((String)message);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deletePfRole(PfRoleVo pfRoleVo) {
        try {
            this.pfRoleMapper.deletePfRole(pfRoleVo.getRoleId());
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("roleId", pfRoleVo.getRoleId());
            this.pfAuthorizeMapper.deletePfAuthorize(param);
            return ResCommonResult.success((String)"\u5220\u9664\u89d2\u8272\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u5220\u9664\u89d2\u8272\u5931\u8d25\uff01");
        }
    }
}

