/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.entity.PfOrganDo;
import cn.gtmap.realestate.core.mapper.PfOrganMapper;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.service.PfOrganService;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class PfOrganServiceImpl
implements PfOrganService {
    @Autowired
    private PfOrganMapper pfOrganMapper;

    public String toPfOrganList() {
        return "organ/pfOrganList";
    }

    public String toPfOrganForm(String superOrganId, String id, String way, Model model) {
        model.addAttribute("way", (Object)way);
        List pfOrganList = this.pfOrganMapper.getPfOrganList();
        if (StringUtils.equals((CharSequence)way, (CharSequence)"modify")) {
            List childrenOrganlist = this.pfOrganMapper.getChildrenOrganList(id);
            if (null != pfOrganList && pfOrganList.size() != 0 && StringUtils.isNotBlank((CharSequence)id)) {
                for (int i = pfOrganList.size() - 1; i >= 0; --i) {
                    if (StringUtils.equals((CharSequence)((PfOrganDo)pfOrganList.get(i)).getOrganId(), (CharSequence)id)) {
                        model.addAttribute("organ", pfOrganList.get(i));
                        pfOrganList.remove(i);
                        continue;
                    }
                    if (!childrenOrganlist.contains(((PfOrganDo)pfOrganList.get(i)).getOrganId())) continue;
                    pfOrganList.remove(i);
                }
            }
        } else {
            model.addAttribute("organ", (Object)new PfOrganDo());
        }
        model.addAttribute("superOrganList", (Object)pfOrganList);
        return "organ/pfOrganForm";
    }

    public String getPfOrganJson() {
        List pfOrganList = this.pfOrganMapper.getPfOrganList();
        return this.organizePfOrganTree(pfOrganList);
    }

    private String organizePfOrganTree(List<PfOrganDo> pfOrganDoList) {
        LinkedList<PfOrganDo> superPfOrganDoList = new LinkedList<PfOrganDo>();
        for (PfOrganDo currPfOrganDo : pfOrganDoList) {
            if (!StringUtils.isBlank((CharSequence)currPfOrganDo.getSuperOrganId())) continue;
            superPfOrganDoList.add(currPfOrganDo);
        }
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (PfOrganDo superOrgan : superPfOrganDoList) {
            Map propertyMap = this.getPropertiesMap(superOrgan);
            propertyMap.put("children", this.organizeTree(superOrgan, pfOrganDoList, propertyMap));
            mapList.add(propertyMap);
        }
        return JSON.toJSONString(mapList);
    }

    public String getRegionCodeByUserId(String userId) {
        List lstOrgan = this.pfOrganMapper.getPfOrganList();
        List organList = this.pfOrganMapper.getPfOrganListByUserId(userId);
        if (organList.size() > 0) {
            return this.dualRegionCode(lstOrgan, (PfOrganDo)organList.get(0));
        }
        return null;
    }

    private Map<String, Object> getPropertiesMap(PfOrganDo pfOrganDo) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
        propertyMap.put("id", pfOrganDo.getOrganId());
        propertyMap.put("name", pfOrganDo.getOrganName());
        propertyMap.put("email", pfOrganDo.getEmail());
        propertyMap.put("officeTel", pfOrganDo.getOfficeTel());
        propertyMap.put("regionCode", pfOrganDo.getRegionCode());
        propertyMap.put("parentId", pfOrganDo.getSuperOrganId());
        propertyMap.put("isParent", true);
        propertyMap.put("organNo", pfOrganDo.getOrganNo());
        return propertyMap;
    }

    private List<Map> organizeTree(PfOrganDo superOrgan, List<PfOrganDo> pfOrganDoList, Map<String, Object> superPropertyMap) {
        ArrayList<Map> jsonMap = new ArrayList<Map>();
        Boolean flag = false;
        for (PfOrganDo currPfOrganDo : pfOrganDoList) {
            if (!StringUtils.equals((CharSequence)currPfOrganDo.getSuperOrganId(), (CharSequence)superOrgan.getOrganId())) continue;
            flag = true;
            Map propertyMap = this.getPropertiesMap(currPfOrganDo);
            propertyMap.put("children", this.organizeTree(currPfOrganDo, pfOrganDoList, propertyMap));
            jsonMap.add(propertyMap);
        }
        if (!flag.booleanValue()) {
            superPropertyMap.put("isParent", false);
        }
        return jsonMap;
    }

    private String dualRegionCode(List<PfOrganDo> organList, PfOrganDo organ) {
        if (StringUtils.isNotBlank((CharSequence)organ.getRegionCode())) {
            return organ.getRegionCode();
        }
        if (StringUtils.isNotBlank((CharSequence)organ.getSuperOrganId())) {
            for (PfOrganDo o : organList) {
                if (!o.getOrganId().equals(organ.getSuperOrganId())) continue;
                if (StringUtils.isNotBlank((CharSequence)o.getRegionCode())) {
                    return o.getRegionCode();
                }
                return this.dualRegionCode(organList, o);
            }
        }
        return null;
    }

    public ResCommonResult deletePfOrgan(String id, String havingChildren) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return ResCommonResult.error();
        }
        param.put("organId", id);
        if (StringUtils.isNotBlank((CharSequence)havingChildren)) {
            param.put("havingChildren", havingChildren);
        }
        return this.pfOrganMapper.deletePfOrgan(param) != false ? ResCommonResult.success((String)"\u5220\u9664\u6210\u529f\uff01") : ResCommonResult.error((String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    public ResCommonResult insertPfOrgan(PfOrganDo pfOrganDo) {
        return this.pfOrganMapper.insertPfOrgan(pfOrganDo) != false ? ResCommonResult.success((String)"\u65b0\u589e\u6210\u529f\uff01") : ResCommonResult.error((String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    public ResCommonResult updatePfOrgan(PfOrganDo pfOrganDo) {
        return this.pfOrganMapper.updatePfOrgan(pfOrganDo) != false ? ResCommonResult.success((String)"\u4fee\u6539\u6210\u529f\uff01") : ResCommonResult.error((String)"\u4fee\u6539\u5931\u8d25\uff01");
    }
}

