/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.entity.PfMenuDo;
import cn.gtmap.realestate.core.mapper.PfAuthorizeMapper;
import cn.gtmap.realestate.core.mapper.PfMenuMapper;
import cn.gtmap.realestate.core.mapper.PfResourceMapper;
import cn.gtmap.realestate.core.mapper.PfRoleMapper;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.service.PfMenuService;
import cn.gtmap.realestate.core.service.PfRoleService;
import cn.gtmap.realestate.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class PfMenuServiceImpl
implements PfMenuService {
    @Autowired
    private PfMenuMapper pfMenuMapper;
    @Autowired
    private PfResourceMapper pfResourceMapper;
    @Autowired
    private PfRoleService pfRoleService;
    @Autowired
    private PfRoleMapper pfRoleMapper;
    @Autowired
    private PfAuthorizeMapper pfAuthorizeMapper;

    public String toPfMenuList(Model model) {
        return "menu/pfMenuList";
    }

    public String getPfMenuJson() {
        List pfMenuList = this.pfMenuMapper.getPfMenuList(null);
        LinkedList<Map> mapList = new LinkedList<Map>();
        Map menuMap = null;
        for (PfMenuDo pfMenuDo : pfMenuList) {
            if (!StringUtils.isBlank((CharSequence)pfMenuDo.getMenuParentId())) continue;
            menuMap = this.getPropertyMap(pfMenuDo);
            menuMap.put("children", this.getPfMenuTreeNode(pfMenuDo, menuMap, pfMenuList));
            menuMap.put("isParent", true);
            break;
        }
        mapList.add(menuMap);
        return JSON.toJSONString(mapList);
    }

    public String toPfMenuForm(Model model, String type, String menuParentId, String id) {
        model.addAttribute("parentMenu", (Object)this.pfMenuMapper.getPfMenuById(menuParentId));
        model.addAttribute("type", (Object)type);
        model.addAttribute("resourceList", (Object)this.pfResourceMapper.getPfResourceDoList(null));
        model.addAttribute("menuList", (Object)this.pfMenuMapper.getPfMenuList(null));
        model.addAttribute("currMenu", (Object)(StringUtils.equals((CharSequence)type, (CharSequence)"modify") ? this.pfMenuMapper.getPfMenuById(id) : new PfMenuDo()));
        return "menu/pfMenuForm";
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult insertPfMenu(PfMenuDo pfMenuDo) {
        try {
            pfMenuDo.setMenuId(StrUtil.getUUID32());
            this.pfMenuMapper.insertPfMenu(pfMenuDo);
            return ResCommonResult.success((String)"\u65b0\u589e\u83dc\u5355\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u65b0\u589e\u83dc\u5355\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult updatePfMenu(PfMenuDo pfMenuDo) {
        return this.pfMenuMapper.updatePfMenu(pfMenuDo) != false ? ResCommonResult.success((String)"\u4fee\u6539\u83dc\u5355\u9879\u6210\u529f\uff01") : ResCommonResult.error((String)"\u4fee\u6539\u83dc\u5355\u9879\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deletePfMenu(String menuId, Boolean havingChildren) {
        PfMenuDo pfMenuDo = this.pfMenuMapper.getPfMenuById(menuId);
        try {
            if (havingChildren.booleanValue()) {
                this.deleteMenuTree(pfMenuDo);
            }
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("menuId", menuId);
            this.pfMenuMapper.deletePfMenu(param);
            this.pfAuthorizeMapper.deletePfAuthorize(param);
            return ResCommonResult.success((String)"\u5220\u9664\u83dc\u5355\u6210\u529f!");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u5220\u9664\u83dc\u5355\u5931\u8d25\uff01");
        }
    }

    private List<Map> getPfMenuTreeNode(PfMenuDo superPfMenudo, Map<String, Object> superMenuMap, List<PfMenuDo> pfMenuDoList) {
        LinkedList<Map> children = new LinkedList<Map>();
        for (PfMenuDo pfMenuDo : pfMenuDoList) {
            if (!StringUtils.equals((CharSequence)pfMenuDo.getMenuParentId(), (CharSequence)superPfMenudo.getMenuId())) continue;
            Map menuMap = this.getPropertyMap(pfMenuDo);
            menuMap.put("children", this.getPfMenuTreeNode(pfMenuDo, menuMap, pfMenuDoList));
            superMenuMap.put("isParent", true);
            children.add(menuMap);
        }
        return children;
    }

    private Map<String, Object> getPropertyMap(PfMenuDo pfMenuDo) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
        propertyMap.put("id", pfMenuDo.getMenuId());
        propertyMap.put("name", pfMenuDo.getMenuName());
        propertyMap.put("menuOrder", pfMenuDo.getMenuOrder());
        propertyMap.put("menuParentId", pfMenuDo.getMenuParentId());
        propertyMap.put("resourceId", pfMenuDo.getResourceId());
        propertyMap.put("resourceName", pfMenuDo.getResourceName());
        propertyMap.put("resourceUrl", pfMenuDo.getResourceUrl());
        propertyMap.put("isParent", false);
        return propertyMap;
    }

    private void deleteMenuTree(PfMenuDo pfMenuDo) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("menuParentId", pfMenuDo.getMenuId());
        List pfMenuDoList = this.pfMenuMapper.getPfMenuList(param);
        if (pfMenuDoList.size() != 0) {
            for (PfMenuDo pfMenuDo1 : pfMenuDoList) {
                param.put("menuParentId", pfMenuDo.getMenuId());
                this.deleteMenuTree(pfMenuDo1);
            }
        } else {
            param.clear();
            param.put("menuId", pfMenuDo.getMenuId());
            this.pfMenuMapper.deletePfMenu(param);
        }
    }
}

