/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.service.impl;

import cn.gtmap.realestate.core.entity.PfBusinessDo;
import cn.gtmap.realestate.core.entity.PfBusinessResourceVo;
import cn.gtmap.realestate.core.entity.PfPartitionInfoDo;
import cn.gtmap.realestate.core.entity.PfResourceDo;
import cn.gtmap.realestate.core.entity.PfResourceGroupDo;
import cn.gtmap.realestate.core.entity.PfResourcePartitionDo;
import cn.gtmap.realestate.core.mapper.PfAuthorizeMapper;
import cn.gtmap.realestate.core.mapper.PfBusinessMapper;
import cn.gtmap.realestate.core.mapper.PfPartitionMapper;
import cn.gtmap.realestate.core.mapper.PfResourceGroupMapper;
import cn.gtmap.realestate.core.mapper.PfResourceMapper;
import cn.gtmap.realestate.core.model.ResCommonResult;
import cn.gtmap.realestate.core.model.em.LoadModeEnum;
import cn.gtmap.realestate.core.model.em.ResourceEnum;
import cn.gtmap.realestate.core.model.em.ResourceTypeEnum;
import cn.gtmap.realestate.core.service.PfBusinessService;
import cn.gtmap.realestate.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.DozerBeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class PfBusinessServiceImpl
implements PfBusinessService {
    @Autowired
    private PfBusinessMapper pfBusinessMapper;
    @Autowired
    private PfResourceGroupMapper pfResourceGroupMapper;
    @Autowired
    private PfResourceMapper pfResourceMapper;
    @Resource(name="org.dozer.Mapper")
    private DozerBeanMapper dozerBeanMapper;
    @Autowired
    private PfPartitionMapper pfPartitionMapper;
    @Autowired
    private PfAuthorizeMapper pfAuthorizeMapper;

    public String toPfBusinessList() {
        return "business/pfBusinessList";
    }

    public String toPfBusinessForm(String id, Model model) {
        model.addAttribute("type", (Object)"business");
        HashMap<String, String> param = new HashMap<String, String>(1);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            param.put("businessId", id);
            PfBusinessDo pfBusinessDo = this.pfBusinessMapper.getPfBusiness(param);
            model.addAttribute("businessDo", (Object)pfBusinessDo);
        }
        return "business/pfBusinessForm";
    }

    public String toPfResourceGroupForm(String businessId, String id, Model model) {
        model.addAttribute("type", (Object)"group");
        model.addAttribute("businessList", (Object)this.pfBusinessMapper.getPfBusinessList(null));
        if (StringUtils.isNotBlank((CharSequence)id)) {
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("groupId", id);
            PfResourceGroupDo pfResourceGroupDo = this.pfResourceGroupMapper.getPfResourceGroupInfo(param);
            model.addAttribute("groupDo", (Object)pfResourceGroupDo);
        } else {
            model.addAttribute("businessId", (Object)businessId);
        }
        return "business/pfResourceGroupForm";
    }

    public String toPfResourceForm(String businessId, String groupId, String id, Model model) {
        model.addAttribute("type", (Object)"resource");
        model.addAttribute("businessList", (Object)this.pfBusinessMapper.getPfBusinessList(null));
        model.addAttribute("resourceTypeMap", (Object)ResourceTypeEnum.getEnumList());
        model.addAttribute("loadModeMap", (Object)LoadModeEnum.getEnumList());
        HashMap<String, String> param = new HashMap<String, String>(2);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            param.put("resourceId", id);
            PfResourceDo pfResourceDo = this.pfResourceMapper.getPfResourceInfo(param);
            model.addAttribute("resourceDo", (Object)pfResourceDo);
            PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
            pfResourceGroupDo.setBusinessId(pfResourceDo.getBusinessId());
            model.addAttribute("groupList", (Object)this.pfResourceGroupMapper.getPfResourceGroupDoList(pfResourceGroupDo));
        } else {
            model.addAttribute("businessId", (Object)businessId);
            model.addAttribute("groupId", (Object)groupId);
            model.addAttribute("groupList", (Object)this.pfResourceGroupMapper.getPfResourceGroupDoList(null));
        }
        return "business/pfResourceForm";
    }

    public String toPfPartitionForm(String resourceId, Model model) {
        model.addAttribute("resourceId", (Object)resourceId);
        return "business/pfPartitionForm";
    }

    public String toPfResourcePartitionForm(String type, String partitionId, String resourceId, Model model) {
        model.addAttribute("type", (Object)type);
        model.addAttribute("resourceId", (Object)resourceId);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"modify")) {
            model.addAttribute("resourcePartitionDo", (Object)this.pfPartitionMapper.getPfResourcePartitionById(partitionId));
        } else {
            model.addAttribute("resourcePartitionDo", (Object)new PfResourcePartitionDo());
        }
        return "business/pfResourcePartitionForm";
    }

    public String toPfPartitionInfoForm(String type, String pfPartitionInfoId, String partitionId, Model model) {
        model.addAttribute("type", (Object)type);
        model.addAttribute("partitionId", (Object)partitionId);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"modify")) {
            model.addAttribute("partitionInfoDo", (Object)this.pfPartitionMapper.getPfPartitionInfoById(pfPartitionInfoId));
        } else {
            model.addAttribute("partitionInfoDo", (Object)new PfPartitionInfoDo());
        }
        return "business/pfPartitionInfoForm";
    }

    public Object getPfBusinessList(PfBusinessDo pfBusinessDo) {
        return ResCommonResult.success((Object)this.pfBusinessMapper.getPfBusinessList(pfBusinessDo));
    }

    public Object getPfResourcePartitionList(PfResourcePartitionDo pfResourcePartitionDo) {
        return ResCommonResult.success((Object)this.pfPartitionMapper.getPfResourcePartitionList(pfResourcePartitionDo));
    }

    public Object getPfPartitionInfoList(PfPartitionInfoDo pfPartitionInfoDo) {
        return ResCommonResult.success((Object)this.pfPartitionMapper.getPfPartitionInfoList(pfPartitionInfoDo));
    }

    public String orgBusinessResouce() {
        List pfBusinessDoList = this.pfBusinessMapper.getPfBusinessList(null);
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (PfBusinessDo pfBusinessDo : pfBusinessDoList) {
            Boolean flag = false;
            Map propertyMap = this.getPropertiesMap(pfBusinessDo);
            PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
            pfResourceGroupDo.setBusinessId(pfBusinessDo.getBusinessId());
            List pfResourceGroupDoList = this.pfResourceGroupMapper.getPfResourceGroupDoList(pfResourceGroupDo);
            LinkedList<Map> prgMapList = new LinkedList<Map>();
            if (null != pfResourceGroupDoList && pfResourceGroupDoList.size() != 0) {
                flag = true;
                for (PfResourceGroupDo currPrgDo : pfResourceGroupDoList) {
                    Map prgPropertyMap = this.getPropertiesMap(currPrgDo);
                    List resourceList = this.orgResourceGroup(currPrgDo);
                    prgPropertyMap.put("children", resourceList);
                    if (resourceList.size() == 0) {
                        prgPropertyMap.put("isParent", false);
                    }
                    prgMapList.add(prgPropertyMap);
                }
            }
            PfResourceDo pfResourceDo = new PfResourceDo();
            pfResourceDo.setBusinessId(pfBusinessDo.getBusinessId());
            pfResourceDo.setGroupId("noGroup");
            List pfResourceDoList = this.pfResourceMapper.getPfResourceDoList(pfResourceDo);
            if (null != pfResourceDoList && pfResourceDoList.size() != 0) {
                flag = true;
                for (PfResourceDo currPfResourceDo : pfResourceDoList) {
                    Map prPropertyMap = this.getPropertiesMap(currPfResourceDo);
                    prgMapList.add(prPropertyMap);
                }
            }
            propertyMap.put("children", prgMapList);
            if (!flag.booleanValue()) {
                propertyMap.put("isParent", false);
            }
            mapList.add(propertyMap);
        }
        return JSON.toJSONString(mapList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public List<PfResourceGroupDo> getGroupByBusinessId(String businessId) {
        if (StringUtils.isNotBlank((CharSequence)businessId)) {
            PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
            pfResourceGroupDo.setBusinessId(businessId);
            return this.pfResourceGroupMapper.getPfResourceGroupDoList(pfResourceGroupDo);
        }
        return null;
    }

    private List<Map> orgResourceGroup(PfResourceGroupDo pfResourceGroupDo) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        PfResourceDo pfResourceDo = new PfResourceDo();
        pfResourceDo.setGroupId(pfResourceGroupDo.getGroupId());
        List pfResourceDoList = this.pfResourceMapper.getPfResourceDoList(pfResourceDo);
        for (PfResourceDo currPfResourceDo : pfResourceDoList) {
            Map prPropertyMap = this.getPropertiesMap(currPfResourceDo);
            mapList.add(prPropertyMap);
        }
        return mapList;
    }

    private Map<String, Object> getPropertiesMap(PfBusinessDo pfBusinessDo) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
        propertyMap.put("id", pfBusinessDo.getBusinessId());
        propertyMap.put("name", pfBusinessDo.getBusinessName());
        propertyMap.put("no", pfBusinessDo.getBusinessNo());
        propertyMap.put("children", null);
        propertyMap.put("isParent", true);
        propertyMap.put("type", "business");
        return propertyMap;
    }

    private Map<String, Object> getPropertiesMap(PfResourceGroupDo pfResourceGroupDo) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
        propertyMap.put("id", pfResourceGroupDo.getGroupId());
        propertyMap.put("name", pfResourceGroupDo.getGroupName());
        propertyMap.put("no", null);
        propertyMap.put("children", null);
        propertyMap.put("isParent", true);
        propertyMap.put("type", "group");
        propertyMap.put("businessId", pfResourceGroupDo.getBusinessId());
        return propertyMap;
    }

    private Map<String, Object> getPropertiesMap(PfResourceDo pfResourceDo) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
        propertyMap.put("id", pfResourceDo.getResourceId());
        propertyMap.put("name", pfResourceDo.getResourceName());
        propertyMap.put("no", pfResourceDo.getResourceNo());
        propertyMap.put("children", null);
        propertyMap.put("isParent", false);
        propertyMap.put("type", "resource");
        return propertyMap;
    }

    public ResCommonResult insert(PfBusinessResourceVo pfBusinessResourceVo) {
        if (StringUtils.equals((CharSequence)pfBusinessResourceVo.getType(), (CharSequence)ResourceEnum.RESOURCE_BUSINESS.getCode())) {
            return this.insertPfBusiness(pfBusinessResourceVo);
        }
        if (StringUtils.equals((CharSequence)pfBusinessResourceVo.getType(), (CharSequence)ResourceEnum.RESOURCE_GROUP.getCode())) {
            return this.insertPfResourceGroup(pfBusinessResourceVo);
        }
        return this.insertPfResource(pfBusinessResourceVo);
    }

    public ResCommonResult update(PfBusinessResourceVo pfBusinessResourceVo) {
        if (StringUtils.equals((CharSequence)pfBusinessResourceVo.getType(), (CharSequence)ResourceEnum.RESOURCE_BUSINESS.getCode())) {
            return this.updatePfBusiness(pfBusinessResourceVo);
        }
        if (StringUtils.equals((CharSequence)pfBusinessResourceVo.getType(), (CharSequence)ResourceEnum.RESOURCE_GROUP.getCode())) {
            return this.updatePfResourceGroup(pfBusinessResourceVo);
        }
        return this.updatePfResource(pfBusinessResourceVo);
    }

    public ResCommonResult delete(PfBusinessResourceVo pfBusinessResourceVo) {
        if (StringUtils.equals((CharSequence)pfBusinessResourceVo.getType(), (CharSequence)ResourceEnum.RESOURCE_BUSINESS.getCode())) {
            return this.deletePfBusiness(pfBusinessResourceVo);
        }
        if (StringUtils.equals((CharSequence)pfBusinessResourceVo.getType(), (CharSequence)ResourceEnum.RESOURCE_GROUP.getCode())) {
            return this.deletePfResourceGroup(pfBusinessResourceVo);
        }
        return this.deletePfResource(pfBusinessResourceVo);
    }

    public ResCommonResult deletePfResource(PfBusinessResourceVo pfBusinessResourceVo) {
        PfResourceDo pfResourceDo = new PfResourceDo();
        pfResourceDo.setResourceId(pfBusinessResourceVo.getId());
        return this.pfResourceMapper.deletePfResource(pfResourceDo) != false ? ResCommonResult.success((String)"\u5220\u9664\u8d44\u6e90\u6210\u529f\uff01") : ResCommonResult.error((String)"\u5220\u9664\u8d44\u6e90\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deletePfResourceGroup(PfBusinessResourceVo pfBusinessResourceVo) {
        PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
        pfResourceGroupDo.setGroupId(pfBusinessResourceVo.getId());
        Boolean result = this.pfResourceGroupMapper.deletePfResourceGroup(pfResourceGroupDo);
        if (result.booleanValue()) {
            if (pfBusinessResourceVo.getHavingChildren().booleanValue()) {
                PfResourceDo pfResourceDo = new PfResourceDo();
                pfResourceDo.setGroupId(pfBusinessResourceVo.getId());
                return this.pfResourceMapper.deletePfResource(pfResourceDo) != false ? ResCommonResult.success((String)"\u5220\u9664\u8d44\u6e90\u7ec4\u53ca\u8d44\u6e90\u6210\u529f\uff01") : ResCommonResult.error((String)"\u5220\u9664\u8d44\u6e90\u7ec4\u53ca\u8d44\u6e90\u5931\u8d25\uff01");
            }
            return ResCommonResult.success((String)"\u5220\u9664\u8d44\u6e90\u7ec4\u6210\u529f\uff01");
        }
        return ResCommonResult.error((String)"\u5220\u9664\u8d44\u6e90\u7ec4\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deletePfBusiness(PfBusinessResourceVo pfBusinessResourceVo) {
        PfBusinessDo pfBusinessDo = new PfBusinessDo();
        pfBusinessDo.setBusinessId(pfBusinessResourceVo.getId());
        StringBuilder message = new StringBuilder();
        Boolean result = this.pfBusinessMapper.deletePfBusiness(pfBusinessDo);
        if (result.booleanValue()) {
            if (pfBusinessResourceVo.getHavingChildren().booleanValue()) {
                PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
                pfResourceGroupDo.setBusinessId(pfBusinessResourceVo.getId());
                List pfResourceGroupDoList = this.pfResourceGroupMapper.getPfResourceGroupDoList(pfResourceGroupDo);
                if (pfResourceGroupDoList.size() > 0) {
                    result = this.pfResourceGroupMapper.deletePfResourceGroup(pfResourceGroupDo);
                    if (!result.booleanValue()) {
                        message.append("\u5220\u9664\u4e1a\u52a1\u4e0b\u7684\u8d44\u6e90\u7ec4\u5931\u8d25\uff01");
                    } else {
                        message.append("\u5220\u9664\u4e1a\u52a1\u4e0b\u7684\u8d44\u6e90\u7ec4\u6210\u529f\uff01");
                    }
                }
                PfResourceDo pfResourceDo = new PfResourceDo();
                pfResourceDo.setBusinessId(pfBusinessResourceVo.getId());
                List pfResourceDoList = this.pfResourceMapper.getPfResourceDoList(pfResourceDo);
                if (pfResourceDoList.size() > 0) {
                    result = this.pfResourceMapper.deletePfResource(pfResourceDo);
                    if (!result.booleanValue()) {
                        return ResCommonResult.error((String)message.append("\u5220\u9664\u4e1a\u52a1\u4e0b\u7684\u8d44\u6e90\u5931\u8d25\uff01").toString());
                    }
                    return ResCommonResult.success((Object)message.append("\u5220\u9664\u4e1a\u52a1\u4e0b\u7684\u8d44\u6e90\u6210\u529f\uff01"));
                }
            }
            return ResCommonResult.success((String)"\u5220\u9664\u4e1a\u52a1\u6210\u529f\uff01");
        }
        return ResCommonResult.error((String)"\u5220\u9664\u4e1a\u52a1\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResCommonResult deletePfResourcePartition(PfResourcePartitionDo pfResourcePartitionDo) {
        try {
            this.pfPartitionMapper.deletePfResourcePartition(pfResourcePartitionDo);
            PfPartitionInfoDo pfPartitionInfoDo = new PfPartitionInfoDo();
            pfPartitionInfoDo.setPartitionId(pfResourcePartitionDo.getPartitionId());
            List partitionInfoDoList = this.pfPartitionMapper.getPfPartitionInfoList(pfPartitionInfoDo);
            if (!partitionInfoDoList.isEmpty()) {
                for (PfPartitionInfoDo pfPartitionInfoDo1 : partitionInfoDoList) {
                    this.pfPartitionMapper.deletePfPartitionInfo(pfPartitionInfoDo1);
                }
            }
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("authorizeObjId", pfResourcePartitionDo.getPartitionId());
            this.pfAuthorizeMapper.deletePfAuthorize(param);
            return ResCommonResult.success((String)"\u5220\u9664\u8d44\u6e90\u5206\u533a\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u5220\u9664\u8d44\u6e90\u5206\u533a\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult deletePfPartitionInfo(PfPartitionInfoDo pfPartitionInfoDo) {
        try {
            this.pfPartitionMapper.deletePfPartitionInfo(pfPartitionInfoDo);
            return ResCommonResult.success((String)"\u5220\u9664\u5206\u533a\u5143\u7d20\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u5220\u9664\u5206\u533a\u5143\u7d20\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult insertPfBusiness(PfBusinessResourceVo pfBusinessResourceVo) {
        PfBusinessDo pfBusinessDo = new PfBusinessDo();
        this.dozerBeanMapper.map((Object)pfBusinessResourceVo, (Object)pfBusinessDo);
        return this.pfBusinessMapper.add(pfBusinessDo) != false ? ResCommonResult.success((String)"\u65b0\u589e\u4e1a\u52a1\u6210\u529f\uff01") : ResCommonResult.error((String)"\u65b0\u589e\u4e1a\u52a1\u5931\u8d25\uff01");
    }

    public ResCommonResult insertPfResourceGroup(PfBusinessResourceVo pfBusinessResourceVo) {
        PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
        this.dozerBeanMapper.map((Object)pfBusinessResourceVo, (Object)pfResourceGroupDo);
        return this.pfResourceGroupMapper.insertPfResourceGroup(pfResourceGroupDo) != false ? ResCommonResult.success((String)"\u65b0\u589e\u8d44\u6e90\u7ec4\u6210\u529f\uff01") : ResCommonResult.error((String)"\u65b0\u589e\u8d44\u6e90\u7ec4\u5931\u8d25\uff01");
    }

    public ResCommonResult insertPfResource(PfBusinessResourceVo pfBusinessResourceVo) {
        PfResourceDo pfResourceDo = new PfResourceDo();
        this.dozerBeanMapper.map((Object)pfBusinessResourceVo, (Object)pfResourceDo);
        return this.pfResourceMapper.insertPfResource(pfResourceDo) != false ? ResCommonResult.success((String)"\u65b0\u589e\u8d44\u6e90\u6210\u529f\uff01") : ResCommonResult.error((String)"\u65b0\u589e\u8d44\u6e90\u5931\u8d25\uff01");
    }

    public ResCommonResult insertPfResourcePartition(PfResourcePartitionDo pfResourcePartitionDo) {
        pfResourcePartitionDo.setPartitionId(StrUtil.getUUID32());
        try {
            this.pfPartitionMapper.insertPfResourcePartition(pfResourcePartitionDo);
            return ResCommonResult.success((String)"\u65b0\u589e\u8d44\u6e90\u5206\u533a\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u65b0\u589e\u8d44\u6e90\u5206\u533a\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult insertPfPartitionInfo(PfPartitionInfoDo pfPartitionInfoDo) {
        pfPartitionInfoDo.setPfPartitionInfoId(StrUtil.getUUID32());
        try {
            this.pfPartitionMapper.insertPfPartitionInfo(pfPartitionInfoDo);
            return ResCommonResult.success((String)"\u65b0\u589e\u5206\u533a\u5143\u7d20\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u65b0\u589e\u5206\u533a\u5143\u7d20\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult updatePfBusiness(PfBusinessResourceVo pfBusinessResourceVo) {
        PfBusinessDo pfBusinessDo = new PfBusinessDo();
        this.dozerBeanMapper.map((Object)pfBusinessResourceVo, (Object)pfBusinessDo);
        return this.pfBusinessMapper.updatePfBusiness(pfBusinessDo) != false ? ResCommonResult.success((String)"\u4fee\u6539\u4e1a\u52a1\u6210\u529f\uff01") : ResCommonResult.error((String)"\u4fee\u6539\u4e1a\u52a1\u5931\u8d25\uff01");
    }

    public ResCommonResult updatePfResourceGroup(PfBusinessResourceVo pfBusinessResourceVo) {
        PfResourceGroupDo pfResourceGroupDo = new PfResourceGroupDo();
        this.dozerBeanMapper.map((Object)pfBusinessResourceVo, (Object)pfResourceGroupDo);
        return this.pfResourceGroupMapper.updatePfResourceGroup(pfResourceGroupDo) != false ? ResCommonResult.success((String)"\u4fee\u6539\u8d44\u6e90\u7ec4\u6210\u529f\uff01") : ResCommonResult.error((String)"\u4fee\u6539\u8d44\u6e90\u7ec4\u5931\u8d25\uff01");
    }

    public ResCommonResult updatePfResource(PfBusinessResourceVo pfBusinessResourceVo) {
        PfResourceDo pfResourceDo = new PfResourceDo();
        this.dozerBeanMapper.map((Object)pfBusinessResourceVo, (Object)pfResourceDo);
        return this.pfResourceMapper.updatePfResource(pfResourceDo) != false ? ResCommonResult.success((String)"\u4fee\u6539\u8d44\u6e90\u6210\u529f\uff01") : ResCommonResult.error((String)"\u4fee\u6539\u8d44\u6e90\u5931\u8d25\uff01");
    }

    public ResCommonResult updatePfResourcePartition(PfResourcePartitionDo pfResourcePartitionDo) {
        try {
            this.pfPartitionMapper.updatePfResourcePartition(pfResourcePartitionDo);
            return ResCommonResult.success((String)"\u4fee\u6539\u8d44\u6e90\u5206\u533a\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u4fee\u6539\u8d44\u6e90\u5206\u533a\u5931\u8d25\uff01");
        }
    }

    public ResCommonResult updatePfPartitionInfo(PfPartitionInfoDo pfPartitionInfoDo) {
        try {
            this.pfPartitionMapper.deletePfPartitionInfo(pfPartitionInfoDo);
            return ResCommonResult.success((String)"\u4fee\u6539\u5206\u533a\u5143\u7d20\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ResCommonResult.error((String)"\u4fee\u6539\u5206\u533a\u5143\u7d20\u5931\u8d25\uff01");
        }
    }
}

