/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.model;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class AuthorityInfo
implements GrantedAuthority {
    private static final long serialVersionUID = 1L;
    private String role;

    public AuthorityInfo(String role) {
        Assert.hasText((String)role, (String)"A granted authority textual representation is required");
        this.role = role;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return obj.equals(this.role);
        }
        if (obj instanceof GrantedAuthority) {
            GrantedAuthority attr = (GrantedAuthority)obj;
            return this.role.equals(attr.getAuthority());
        }
        return false;
    }

    public String getAuthority() {
        return this.role;
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public String toString() {
        return this.role;
    }

    public int compareTo(Object o) {
        if (o instanceof GrantedAuthority) {
            String rhsRole = ((GrantedAuthority)o).getAuthority();
            if (rhsRole == null) {
                return -1;
            }
            return this.role.compareTo(rhsRole);
        }
        return -1;
    }
}

