/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.config.security;

import cn.gtmap.realestate.config.security.Md5PasswordEncoder;
import cn.gtmap.realestate.config.security.YunNanPasswordEncoder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfigurer
extends WebSecurityConfigurerAdapter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AuthenticationSuccessHandler defaultAuthenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler defaultAuthenticationFailureHandler;
    @Value(value="${password.encode.type:DEFAULT}")
    String encodeType;
    @Value(value="${password.encode.yunnan.url:}")
    String encodeUrl;

    public PasswordEncoder md5PasswordEncoder() {
        return new Md5PasswordEncoder();
    }

    public PasswordEncoder yunNanPasswordEncoder() {
        return new YunNanPasswordEncoder(this.encodeUrl);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (StringUtils.equals((CharSequence)this.encodeType, (CharSequence)"YUNNAN")) {
            auth.userDetailsService(this.userDetailsService).passwordEncoder(this.yunNanPasswordEncoder());
        } else {
            auth.userDetailsService(this.userDetailsService).passwordEncoder(this.md5PasswordEncoder());
        }
    }

    public void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions();
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().mvcMatchers(new String[]{"/static/**"}).permitAll().mvcMatchers(new String[]{"/webjars/**"}).permitAll().mvcMatchers(new String[]{"/loginView"}).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage("/loginView").loginProcessingUrl("/login")).usernameParameter("uname").passwordParameter("passwd").successHandler(this.defaultAuthenticationSuccessHandler)).failureHandler(this.defaultAuthenticationFailureHandler)).and()).csrf().disable()).sessionManagement().invalidSessionUrl("/loginView").maximumSessions(1).maxSessionsPreventsLogin(false).and().and()).logout().invalidateHttpSession(true).logoutUrl("/logout").logoutSuccessUrl("/loginView");
    }
}

