/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.config.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;

@WebFilter(filterName="xssCookieHttpOnly", urlPatterns={"/*"})
@Order(value=2)
public class CookieHttpOnlyFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                StringBuilder builder = new StringBuilder();
                builder.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
                builder.append("Path").append("=").append(req.getContextPath()).append(";");
                builder.append("HttpOnly; SameSite=Lax");
                resp.setHeader("Set-Cookie", builder.toString());
            }
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

