/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.config;

import cn.gtmap.realestate.util.ConfigConstants;
import cn.gtmap.realestate.util.PropertyUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ConfigEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String path = PropertyUtil.TOMCAT_EGOV_PATH + File.separator + ConfigConstants.ELECTRONIC_CONFIG + File.separator + "application.properties";
        File file = new File(path);
        System.out.println("Loading local settings from : " + path);
        if (file.exists()) {
            MutablePropertySources propertySources = environment.getPropertySources();
            Properties properties = this.loadProperties(file);
            System.out.println(properties.toString());
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("Config", properties));
        }
    }

    private Properties loadProperties(File f) {
        FileSystemResource resource = new FileSystemResource(f);
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load local settings from " + f.getAbsolutePath(), ex);
        }
    }
}

