/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onething.util;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.dto.lsh.LshDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import cn.gtmap.onething.util.PropertiesLoadUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

public class LshUtil {
    public static final Logger log = Logger.getLogger(LshUtil.class);

    public static String getLsh(String lshlx, String lshws) {
        String lsh = null;
        OnethingConfig config = PropertiesLoadUtil.loadOnethingConfigFromJson();
        String lshUrl = config.getServiceAddress() + "/api/v1/getLsh";
        LshDTO lshDTO = new LshDTO(config.getTokenXzqdm(), lshlx, lshws);
        String result = HttpUtil.sendPost(lshUrl, null, "\u4e00\u4ef6\u4e8b-\u83b7\u53d6\u6d41\u6c34\u53f7", JSON.toJSONString((Object)lshDTO), null, null);
        OnethingResultDTO onethingResultDTO = (OnethingResultDTO)JSON.parseObject((String)result, OnethingResultDTO.class);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(onethingResultDTO.getData()));
        lsh = MapUtils.getString((Map)jsonObject, (Object)"lsh");
        return lsh;
    }

    public static String getOnetingInternalNo(String orgId, String onethingCode, OnethingConfig config) {
        String internalNo = null;
        String idNumber = config.getIdNumber(orgId);
        String xscjdm = config.getXscjdm();
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = idNumber + xscjdm + onethingCode + "TC";
        String lsh = LshUtil.getLsh(lshlx, String.valueOf(4));
        internalNo = idNumber + xscjdm + onethingCode + formattedDate + lsh + "TC";
        String loginfo = "\u83b7\u53d6\u4e00\u4ef6\u4e8b\u5168\u7701\u552f\u4e00\u529e\u4ef6\u7f16\u53f7:" + internalNo + ",\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801:" + idNumber + ",\u5c42\u7ea7\u4ee3\u7801:" + xscjdm + ",\u5f53\u524d\u65e5\u671f:" + formattedDate + ",\u4e00\u4ef6\u4e8b\u4e3b\u9898\u7f16\u7801:" + onethingCode + ",\u6d41\u6c34\u53f7\u7c7b\u578b:" + lshlx + ",\u6d41\u6c34\u53f7\u4f4d\u6570:" + 4;
        log.info((Object)loginfo);
        return internalNo;
    }

    public static String getOneMatterInternalNo(String orgId, String onethingCode, OnethingConfig config) {
        String internalNo = null;
        String idNumber = config.getIdNumber(orgId);
        String xscjdm = config.getXscjdm();
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = idNumber + xscjdm + onethingCode;
        String lsh = LshUtil.getLsh(lshlx, String.valueOf(4));
        internalNo = idNumber + xscjdm + onethingCode + formattedDate + lsh;
        String loginfo = "\u83b7\u53d6\u4e00\u4ef6\u4e8b\u5168\u7701\u552f\u4e00\u529e\u4ef6\u7f16\u53f7:" + internalNo + ",\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801:" + idNumber + ",\u5c42\u7ea7\u4ee3\u7801:" + xscjdm + ",\u5f53\u524d\u65e5\u671f:" + formattedDate + ",\u4e00\u4ef6\u4e8b\u4e3b\u9898\u7f16\u7801:" + onethingCode + ",\u6d41\u6c34\u53f7\u7c7b\u578b:" + lshlx + ",\u6d41\u6c34\u53f7\u4f4d\u6570:" + 4;
        log.info((Object)loginfo);
        return internalNo;
    }

    public static String getOneMatterBjNo() {
        String no = null;
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = "DSXBJ";
        String lsh = LshUtil.getLsh(lshlx, String.valueOf(7));
        no = lshlx + formattedDate + lsh;
        log.info((Object)("\u83b7\u53d6\u5355\u4e8b\u9879\u529e\u7ed3NO:" + no));
        return no;
    }

    public static String getOneMatterSpNo() {
        String no = null;
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDate = currentDate.format(formatter);
        String lshlx = "DSXSP";
        String lsh = LshUtil.getLsh(lshlx, String.valueOf(7));
        no = lshlx + formattedDate + lsh;
        log.info((Object)("\u83b7\u53d6\u5355\u4e8b\u9879\u529e\u7ed3NO:" + no));
        return no;
    }
}

