/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onething.util;

import cn.gtmap.onething.exception.OnethingException;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpUtil {
    public static final Logger log = Logger.getLogger(HttpUtil.class);

    public static String sendPost(String url, HashMap<String, String> headers, String jkms, String params, Integer connectionTimeout, Integer readTimeout) {
        log.info((Object)("\u4e00\u4ef6\u4e8b\u63a8\u9001-\u8c03\u7528" + jkms + ",url:" + url + ",headers:" + JSON.toJSONString(headers) + ",params:" + params));
        String result = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            if (connectionTimeout != null) {
                RequestConfig connectTimeoutConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).build();
                httpPost.setConfig(connectTimeoutConfig);
            }
            if (readTimeout != null) {
                RequestConfig readTimeoutConfig = RequestConfig.custom().setSocketTimeout(readTimeout.intValue()).build();
                httpPost.setConfig(readTimeoutConfig);
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpPost.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            StringEntity paramEntity = new StringEntity(params, StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)paramEntity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            result = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error((Object)("\u4e00\u4ef6\u4e8b\u63a8\u9001-" + jkms + "\u8c03\u7528\u5931\u8d25,url:" + url + ",headers:" + JSON.toJSONString(headers) + "params:" + params), (Throwable)e);
            throw new OnethingException(9999, jkms + "\u8c03\u7528\u5931\u8d25");
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error((Object)("\u4e00\u4ef6\u4e8b\u63a8\u9001-" + jkms + "\u5173\u95edhttpClient\u5931\u8d25,url:" + url + ",headers:" + JSON.toJSONString(headers) + "params:" + params), (Throwable)e);
                    throw new OnethingException(9999, jkms + "\u5173\u95edhttpClient\u5931\u8d25");
                }
            }
        }
        log.info((Object)("\u8c03\u7528" + jkms + "\u5b8c\u6210,url:" + url + ",params:" + params + ",\u51fa\u53c2:" + result));
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error((Object)("\u4e00\u4ef6\u4e8b\u63a8\u9001-" + jkms + "\u8c03\u7528\u5931\u8d25,url:" + url + ",headers:" + JSON.toJSONString(headers) + "\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7aparams:" + params));
            throw new OnethingException(9999, jkms + "\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
        }
        return result;
    }
}

