package cn.gtmap.onething.exception;

import lombok.Getter;
import org.apache.log4j.Logger;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2022年11月08日
 * @description 一件事异常
 */
@Getter
public class OnethingException extends RuntimeException {
    public static final Logger log = Logger.getLogger(RuntimeException.class);
    /**
     * code
     */
    private final Integer code;

    /**
     * msg
     */
    private final String msg;


    public OnethingException(Integer code, String msg) {
        super(msg);
        this.code = code;
        this.msg = code + ": " + msg;
    }

    public OnethingException(Integer code, String msg, Throwable throwable) {
        super(msg);
        this.code = code;
        this.msg = code + ": " + msg;
        log.error("一件事-捕获异常详细信息:\n" + throwable.toString());
        this.setStackTrace(throwable.getStackTrace());
    }
}
