package cn.gtmap.onething.entity.dto.onething.sb;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSb;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSbApplyInfo;
import cn.gtmap.onething.util.JointCodeUtil;
import cn.gtmap.onething.util.StringUtil;
import com.gtis.common.util.UUIDGenerator;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class SbApplyInfo {
    private String no;
    private String areaNo;
    private String yearFlag;
    private String jointCode;
    private String onethingCode;
    private String areaName;
    private String onethingName;
    private String applyWay;
    private String applyerType;
    private String applyerName;
    private String idType;
    private String idNumber;
    private String applyDate;
    private String tel;
    private String province;
    private String city;
    private String county;
    private String address;
    private String legalMobile;
    private String legalId;
    private String legal;
    private String status;
    private String formUrl;
    private SbForms forms;
    private SbFormsBrief formsBrief;
    private OnethingExtinfo extInfo;

    public SbApplyInfo(YjsSb yjsSb) {
        YjsSbApplyInfo applyInfo = yjsSb.getApplyInfo();
        OnethingConfig config = yjsSb.getOnethingConfig();
        this.jointCode = JointCodeUtil.getJointCode(yjsSb.getAreaNo(), applyInfo.getOnethingCode());
        this.no = this.jointCode;
        this.areaNo = StringUtil.padZero(yjsSb.getAreaNo(), 12);
        this.areaName = yjsSb.getAreaName();
        this.onethingCode = applyInfo.getOnethingCode();
        this.onethingName = config.getOnethingName(applyInfo.getOnethingCode());
        this.applyWay = applyInfo.getApplyWay();
        this.applyerType = applyInfo.getApplyerType();
        this.applyerName = applyInfo.getApplyerName();
        this.idNumber = applyInfo.getIdNumber();
        this.applyDate = applyInfo.getApplyDate();
        this.status = applyInfo.getStatus();
        this.extInfo = applyInfo.getExtInfo();
        this.forms = new SbForms();
        this.formsBrief = new SbFormsBrief();
        this.idType = applyInfo.getIdType();
        LocalDate currentDate = LocalDate.now();
        int currentYear = currentDate.getYear();
        this.yearFlag = String.valueOf(currentYear);
    }
}
