package cn.gtmap.onething.entity.dto.onematter.sp;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSpProcess;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSpProject;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月11日
 * @description
 */
@Data
public class OmSpProjectInfo {
    private List<OmSpProcess> processlist;

    private List<Map> doclist;

    public OmSpProjectInfo(OnethingConfig config, DsxSpProject dsxSpProject) {
        List<DsxSpProcess> processlist = dsxSpProject.getProcesslist();
        List<OmSpProcess> processlistAdd = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(processlist)) {
            for (DsxSpProcess dsxSpProcess : processlist) {
                OmSpProcess omSpProcess = new OmSpProcess(dsxSpProject.getOrg_id(), config, dsxSpProcess);
                processlistAdd.add(omSpProcess);
            }
        }
        this.processlist = processlistAdd;
        this.doclist = new ArrayList<>();
    }
}
