package cn.gtmap.onething.entity.dto.onematter.sp;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSpProcess;
import cn.gtmap.onething.util.LshUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月11日
 * @description
 */
@Data
public class OmSpProcess {
    private String no;
    private String event_number;
    private String event_code;
    private String event_name;
    private String department;
    private String start_time;
    private String event_time;
    private String event_time_type;
    private String start_note;
    private String start_user_name;
    private String start_tel;
    private String start_phone;
    private String end_time;
    private String end_note;
    private String process_report_name;
    private String process_report;
    private String end_user_name;
    private String remark;
    private String ems_ord_no;
    private String mail_num;
    private String sendtime;
    private String net_type;
    private String eventname;
    private String data_sources;
    private OnethingExtinfo extinfo;

    public OmSpProcess(String org_id, OnethingConfig config, DsxSpProcess dsxSpProcess) {
        this.no = LshUtil.getOneMatterSpNo();
        this.event_number = dsxSpProcess.getEvent_number();
        this.event_code = dsxSpProcess.getEvent_code();
        this.event_name = dsxSpProcess.getEvent_name();
        this.end_time = dsxSpProcess.getEnd_time();
        if (StringUtils.isBlank(dsxSpProcess.getEnd_user_name())) {
            this.end_user_name = config.getDsxSpEndUsername(org_id);
        } else {
            this.end_user_name = dsxSpProcess.getEnd_user_name();
        }
        this.eventname = dsxSpProcess.getEventname();
        this.data_sources = dsxSpProcess.getData_sources();
        this.extinfo = dsxSpProcess.getExtInfo();
    }
}
