package cn.gtmap.onething.entity.dto.onematter.sl;

import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSl;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSlProject;
import cn.gtmap.onething.entity.dto.onematter.sj.OmSjProject;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class OmSlParams {
    private List<OmSlProject> projectlist;

    public OmSlParams(DsxSjSl dsxSjSl) {
        List<OmSlProject> projectlist = new ArrayList<>();
        List<DsxSjSlProject> projectSourcelist = dsxSjSl.getProjectlist();
        if (CollectionUtils.isNotEmpty(projectSourcelist)) {
            for (DsxSjSlProject dsxSjSlProject : projectSourcelist) {
                OmSlProject omSlProject = new OmSlProject(dsxSjSl,dsxSjSlProject);
                projectlist.add(omSlProject);
            }
        }
        this.projectlist = projectlist;
    }
}
