package cn.gtmap.onething.entity.dto.onematter.sj;

import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSl;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSlProject;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class OmSjParams {
    private List<OmSjProject> projectlist;

    public OmSjParams(DsxSjSl dsxSjSl) {
        List<OmSjProject> projectlist = new ArrayList<>();
        List<DsxSjSlProject> projectSourcelist = dsxSjSl.getProjectlist();
        if (CollectionUtils.isNotEmpty(projectSourcelist)) {
            for (DsxSjSlProject dsxSjSlProject : projectSourcelist) {
                OmSjProject omSjProject = new OmSjProject(dsxSjSl,dsxSjSlProject);
                projectlist.add(omSjProject);
            }
        }
        this.projectlist = projectlist;
    }
}
