package cn.gtmap.onething.entity.dto.onematter.bj;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.onematter.bj.DsxBj;
import cn.gtmap.onething.entity.bo.onematter.bj.DsxBjProject;
import lombok.Data;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月11日
 * @description
 */
@Data
public class OmBjProject {
    private String no;
    private String jointCode;
    private String internal_no;
    private String taskHandleItem;
    private String local_itemcode;
    private String opinion;
    private String org_id;
    private OmBjProjectInfo projectinfo;
    private OnethingExtinfo extinfo;

    public OmBjProject(DsxBj dsxBj, DsxBjProject dsxBjProject) {
        String orgId = dsxBjProject.getOrg_id();
        OnethingConfig config = dsxBj.getOnethingConfig();
        this.taskHandleItem = config.getTaskHandleItem(orgId);
        this.projectinfo = new OmBjProjectInfo(dsxBjProject);
        this.org_id = config.getRealOrgId(orgId);
        this.extinfo = dsxBjProject.getExtInfo();
    }
}
