package cn.gtmap.onething.entity.bo.oneting.ys;

import cn.gtmap.estateplat.noemptyannotion.noempty.NoEmptyExecutor;
import cn.gtmap.estateplat.noemptyannotion.noempty.annotion.NoEmpty;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.dto.onething.ys.OnethingYsDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.log4j.Logger;

import javax.validation.Valid;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description 一件事办件预审接口
 */
@Data
public class YjsYs extends OnethingRequest<YjsYsResult> {
    public static final Logger log = Logger.getLogger(YjsYs.class);
    /**
     * 行政区划编码
     */
    @NoEmpty(fieldExplain = "行政区划编码")
    private String xzqdm;

    /**
     * 一件事办件申报信息扩展信息
     */
    @Valid
    @NoEmpty(fieldExplain = "一件事办件申报信息扩展信息")
    private OnethingExtinfo extInfo;

    /**
     * 预审时间
     */
    @NoEmpty(fieldExplain = "预审时间")
    private String pretrialDate;

    /**
     * 预审人员
     */
    @NoEmpty(fieldExplain = "预审人员")
    private String pretrialUserName;

    /**
     * 预审结果
     */
    @NoEmpty(fieldExplain = "预审结果")
    private String result;

    @Override
    public YjsYsResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        this.setJkms("一件事办件预审接口");
        String url = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushPretrialInfo";
        //初始化DTO 作为入参
        OnethingYsDTO onethingYsDTO = new OnethingYsDTO(this);
        String result = HttpUtil.sendPost(url, this.getHeaders(), this.getJkms(), JSON.toJSONString(onethingYsDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        YjsYsResult yjsYsResult = new YjsYsResult();
        yjsYsResult.setCode(onethingResultDTO.getHead().getCode());
        yjsYsResult.setMsg(onethingResultDTO.getHead().getMsg());
        yjsYsResult.setOnethingRequestParam(onethingYsDTO);
        yjsYsResult.setOnethingResultDTO(onethingResultDTO);
        log.info("一件事办件预审接口-最终结果:" + JSON.toJSONString(yjsYsResult));
        return yjsYsResult;
    }
}
