package cn.gtmap.onething.entity.bo.oneting.sl;

import cn.gtmap.estateplat.noemptyannotion.noempty.NoEmptyExecutor;
import cn.gtmap.estateplat.noemptyannotion.noempty.annotion.NoEmpty;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.dto.onething.sl.OnethingSlDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.log4j.Logger;

import javax.validation.Valid;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description 一件事办件受理接口
 */
@Data
public class YjsSl extends OnethingRequest<YjsSlResult> {
    public static final Logger log = Logger.getLogger(YjsSl.class);
    /**
     * 行政区划编码
     */
    @NoEmpty(fieldExplain = "行政区代码")
    private String xzqdm;

    /**
     * 一件事办件申报信息扩展信息
     */
    @Valid
    @NoEmpty(fieldExplain = "一件事办件申报信息扩展信息")
    private OnethingExtinfo extInfo;

    @Valid
    @NoEmpty(fieldExplain = "acceptinfo")
    private YjsSlAcceptInfo acceptinfo;

    @Override
    public YjsSlResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        this.setJkms("一件事办件受理接口");
        String url = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushAcceptInfo";
        //初始化DTO 作为入参
        OnethingSlDTO onethingSlDTO = new OnethingSlDTO(this);
        String result = HttpUtil.sendPost(url, this.getHeaders(), this.getJkms(), JSON.toJSONString(onethingSlDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        YjsSlResult yjsSlResult = new YjsSlResult();
        //入参中获取
        yjsSlResult.setCode(onethingResultDTO.getHead().getCode());
        yjsSlResult.setMsg(onethingResultDTO.getHead().getMsg());
        yjsSlResult.setOnethingRequestParam(onethingSlDTO);
        yjsSlResult.setOnethingResultDTO(onethingResultDTO);
        log.info("一件事办件受理接口-最终结果:" + JSON.toJSONString(yjsSlResult));
        return yjsSlResult;
    }
}
