package cn.gtmap.onething.entity.bo.oneting.sb;

import cn.gtmap.estateplat.noemptyannotion.noempty.NoEmptyExecutor;
import cn.gtmap.estateplat.noemptyannotion.noempty.annotion.NoEmpty;
import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.dto.onething.sb.OnethingSbDTO;
import cn.gtmap.onething.entity.dto.onething.sb.SbProject;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description 一件事办件申报接口
 */
@Data
public class YjsSb extends OnethingRequest<YjsSbResult> {
    public static final Logger log = Logger.getLogger(YjsSb.class);
    /**
     * 行政区划编码
     */
    @NoEmpty(fieldExplain = "行政区划编码")
    private String areaNo;

    /**
     * 行政区划名称
     */
    @NoEmpty(fieldExplain = "行政区划名称")
    private String areaName;

    /**
     * applyInfo
     */
    @Valid
    @NoEmpty(fieldExplain = "applyInfo")
    private YjsSbApplyInfo applyInfo;

    /**
     * projectlist
     */
    @Valid
    @NoEmpty(fieldExplain = "projectlist")
    private List<YjsSbProject> yjsSbProjectList;


    @Override
    public YjsSbResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        this.setJkms("一件事办件申报接口");
        String url = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushApplyInfo";
        //初始化DTO 作为入参
        OnethingSbDTO onethingSbDTO = new OnethingSbDTO(this);
        String result = HttpUtil.sendPost(url, this.getHeaders(), this.getJkms(), JSON.toJSONString(onethingSbDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        YjsSbResult yjsSbResult = new YjsSbResult();
        //入参中获取
        yjsSbResult.setApplyInfoNo(onethingSbDTO.getData().getParams().getApplyInfo().getNo());
        List<YjsSbProjectResult> projectlist = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(onethingSbDTO.getData().getParams().getProjectList())) {
            for (SbProject sbProject : onethingSbDTO.getData().getParams().getProjectList()) {
                YjsSbProjectResult yjsSbProjectResult = new YjsSbProjectResult(sbProject);
                projectlist.add(yjsSbProjectResult);
            }
        }
        yjsSbResult.setProjectlist(projectlist);
        yjsSbResult.setCode(onethingResultDTO.getHead().getCode());
        yjsSbResult.setMsg(onethingResultDTO.getHead().getMsg());
        yjsSbResult.setOnethingRequestParam(onethingSbDTO);
        yjsSbResult.setOnethingResultDTO(onethingResultDTO);
        log.info("一件事办件申报接口-最终结果:" + JSON.toJSONString(yjsSbResult));
        return yjsSbResult;
    }

}
