package cn.gtmap.onething.entity.bo.oneting.bj;

import cn.gtmap.estateplat.noemptyannotion.noempty.NoEmptyExecutor;
import cn.gtmap.estateplat.noemptyannotion.noempty.annotion.NoEmpty;
import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.dto.onething.bj.OnethingBjDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.log4j.Logger;

import javax.validation.Valid;


@Data
public class YjsBj extends OnethingRequest<YjsBjResult> {

    public static final Logger log = Logger.getLogger(YjsBj.class);

    /**
     * 行政区划编码
     */
    @NoEmpty(fieldExplain = "行政区划编码")
    private String xzqdm;

    /**
     * 一件事办件申报信息扩展信息
     */
    @Valid
    @NoEmpty(fieldExplain = "一件事办件申报信息扩展信息")
    private OnethingExtinfo extInfo;

    @Valid
    @NoEmpty(fieldExplain = "finishInfo")
    private YjsBjFinishInfo finishInfo;

    @Override
    public YjsBjResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        log.info("一件事办件办结接口-最终结果:");
        this.setJkms("一件事办件办结接口");
        String url = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushFinishInfo";
        //初始化DTO 作为入参
        OnethingBjDTO onethingBjDTO = new OnethingBjDTO(this);
        String result = HttpUtil.sendPost(url, this.getHeaders(), this.getJkms(), JSON.toJSONString(onethingBjDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        YjsBjResult yjsBjResult = new YjsBjResult();
        //入参中获取
        yjsBjResult.setCode(onethingResultDTO.getHead().getCode());
        yjsBjResult.setMsg(onethingResultDTO.getHead().getMsg());
        yjsBjResult.setOnethingRequestParam(onethingBjDTO);
        yjsBjResult.setOnethingResultDTO(onethingResultDTO);
        log.info("一件事办件办结接口-最终结果:" + JSON.toJSONString(yjsBjResult));
        return yjsBjResult;
    }
}
